-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Linear Voltage-Controlled Voltage Source
-- 
-- Description:
-- IN1 and IN2 are the positive and negative controlling terminals,
-- respectively. The input voltage controls the output voltage
-- between terminal OUTP end the electrical reference node.
-- V is the voltage gain.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- vcvs.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
   use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity VCVS is
   generic (V     : REAL := 1.0 -- voltage gain
           );       
   port    (terminal IN1  : ELECTRICAL;  -- controlling plus terminal
            terminal IN2  : ELECTRICAL;  -- controlling minus terminal
            terminal OUTP : ELECTRICAL   -- output plus terminal
           );
end entity VCVS;

architecture V1 of VCVS is
   quantity VIN  across IN1 to IN2;   -- open branch
   quantity VOUT across IOUT through OUTP;
begin
   VOUT == V*VIN;
end architecture V1;

