-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for A-Law Companding
-- 
-- Description:
-- A 1 kHz sinusoidal voltage (amplitude=2.0) is compressed.
-- The A-law companding model is used with K=5. The simulation
-- should run until 2 ms.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- pd.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.MATH_REAL.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_A_LAW of BENCH is 
    terminal N_IN, N_OUT : ELECTRICAL;
    quantity VIN across IIN through N_IN;
    constant AMPL : REAL := 2.0;
    constant FREQ : REAL := 1.0E3;
begin
    VIN == AMPL*SIN (MATH_2_PI*FREQ*NOW);

UUT: entity COMPRESS(V1)
       generic map (K => 5, VMAX => AMPL)
       port map    (INP => N_IN, OUTP => N_OUT);

end architecture BENCH_A_LAW;  
