-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Delay Block
-- 
-- Description:
-- The sinusoidal voltage at node N_IN is delayed by 250 us.
-- The simulation should run until 2 ms. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    DELAY_BLOCK(IDEAL)
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.5_delay_block/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.MATH_REAL.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_DELAY of BENCH is 
    terminal N_IN, N_OUT : ELECTRICAL;
    quantity VIN across IIN through N_IN;
begin
    VIN == SIN(MATH_2_PI*NOW*1.0E3);

UUT: entity DELAY_BLOCK(IDEAL)
       generic map (T_DELAY => 0.25E-3)
       port map    (INP => N_IN, OUTP => N_OUT);

end architecture BENCH_DELAY;  
