-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Integrator Block
-- 
-- Description:
-- The ramp voltage at node N_IN integrated. The initial value of N_OUT
-- is set to 1.0. The simulation should run until 1 s. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE                    ELECTRICAL_SYSTEMS
-- WORK                    Integrator_BLOCK(IDEAL) 
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.5_integrator/tb/bench.vhd
-- -----------------------------------------------------------


library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.MATH_REAL.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_INTEGRATOR of BENCH is 
    terminal N_IN, N_OUT : ELECTRICAL;
    quantity VIN across IIN through N_IN;
begin
    VIN == NOW;

UUT: entity INTEGRAL_BLOCK(IDEAL)
       generic map (IC => 1.0)
       port map    (INP => N_IN, OUTP => N_OUT);

end architecture BENCH_INTEGRATOR;  
