-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Independent Voltage Pulse Source
-- 
-- Description:
-- The model describes a voltage pulse source. The initial
-- voltage is 0.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- pulse.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
      
entity V_SOURCE is
    generic (AMPL     : REAL := 1.0;      -- pulsed value [V]
             T_DELAY  : TIME := 0.5 ms;   -- delay time [TIME]
             DURATION : TIME := 1 ms;     -- duration of pulse [TIME], MIN >0 fs
	     T_RISE   : REAL := 0.0       -- rise and fall time [s], MIN: >=0.0
            );
    port    (terminal P  : ELECTRICAL;   -- positive terminal 
             terminal N  : ELECTRICAL    -- negative terminal
            );
begin
   assert DURATION > 0 fs
     report "ERROR: DURATION > 0 fs required."
     severity ERROR;
end entity V_SOURCE;   

architecture PULSE of V_SOURCE is
    quantity V across I through P to N;
    signal S_OUT : REAL := 0.0;
begin
    S_OUT <= AMPL after T_DELAY, 0.0 after  T_DELAY + DURATION when DOMAIN = TIME_DOMAIN;
    V == S_OUT'RAMP(T_RISE);
end architecture PULSE;
