-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Lossless Line
-- 
-- Description:
-- The voltage pulse at node N1 is delayed by 1.5 ms.
-- An ideal transmission is carried out if the load
-- resistor equals the characteristic impedance of the
-- lossless line. The default value of the characteristic
-- impedance is 50 Ohm. The simulation should run until 10 ms. 
-- Simulation parameters (hmax, eps) should be carefully
-- chosen.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    V_SOURCE(IDEAL)
-- WORK                    LINE(LOSSLESS)
-- WORK                    RESISTOR(V1)
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.5_line/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use WORK.all;
   
entity BENCH is end entity BENCH;
   
architecture BENCH_LOSSLESS_LINE of BENCH is
    constant R_LOAD     : REAL := 20.0;
    terminal N1, N2     : ELECTRICAL;
begin
   
V1: entity V_SOURCE(PULSE)
       generic map (DURATION => 1 ms)
       port map (P => N1, N => ELECTRICAL_REF);

UUT: entity LINE(LOSSLESS)
       generic map (TD => 1.5e-3)
       port map (T1 => N1, T2 => ELECTRICAL_REF,
                 T3 => N2, T4 => ELECTRICAL_REF);

R1: entity RESISTOR(V1)
       generic map (VALUE_R => R_LOAD)
       port map (N2, ELECTRICAL_REF);
   
end architecture BENCH_LOSSLESS_LINE;

