-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Bessel Lowpass Filter
-- 
-- Description:
-- A voltage pulse of 5 ms duration is filtered by different
-- realizations of Bessel lowpass filters. The simulation should run 
-- until 10 ms. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    V_SOURCE(PULSE)
-- WORK                    LOWPASS(BESSEL_2)
-- WORK                    LOWPASS(BESSEL_4)
-- WORK                    LOWPASS(BESSEL_2_DIGITAL)
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.5_lowpass/tb/bench.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use WORK.all;
   
entity BENCH is end entity BENCH;
   
architecture BENCH_LOWPASS of BENCH is
    terminal N1                  : ELECTRICAL;
    terminal N2_BESSEL_2         : ELECTRICAL;
    terminal N2_BESSEL_4         : ELECTRICAL;
    terminal N1_DIGITAL          : ELECTRICAL;
    terminal N2_BESSEL_2_DIGITAL : ELECTRICAL;
begin
   
V1: entity V_SOURCE(PULSE)
       generic map (DURATION => 5 ms)
       port map (P => N1, N => ELECTRICAL_REF);

UUT1: entity LOWPASS(BESSEL_2)
       generic map (FC => 1.0E3)
       port map (INP => N1, OUTP => N2_BESSEL_2);

UUT2: entity LOWPASS(BESSEL_4)
       generic map (FC => 1.0E3)
       port map (INP => N1, OUTP => N2_BESSEL_4);

V2: entity V_SOURCE(PULSE)
       generic map (DURATION => 5 ms)
       port map (P => N1_DIGITAL, N => ELECTRICAL_REF);

UUT3: entity LOWPASS(BESSEL_2_DIGITAL)
       generic map (FC => 1.0E3)
       port map (INP => N1_DIGITAL, OUTP => N2_BESSEL_2_DIGITAL);

end architecture BENCH_LOWPASS;

