-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:    Signal Flow PID Controller
-- 
-- Description:
-- The model realizes a nonconservative PID controller:
-- Q_OUT equals KR*(Q_IN + 1.0/TN*Q_IN'INTEG + TV*Q_IN'DOT).
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- 
-- -----------------------------------------------------------
--
-- Source:
-- pid.vhd
-- -----------------------------------------------------------
   
entity PID is
  generic (KR : REAL := 1.0;  -- controller gain
           TN : REAL := 1.0;  -- reset time
           TV : REAL := 0.0   -- derivative time
          );
  port (quantity Q_IN  : in  REAL;  -- input quantity
        quantity Q_OUT : out REAL   -- output quantity
          );
begin
  assert TN /= 0.0
    report "ERROR: TN /= 0.0 required."
    severity ERROR;
end entity PID;

architecture IDEAL of PID is
  quantity Q, QI : REAL;
begin
  Q     == Q_IN;
  if DOMAIN = QUIESCENT_DOMAIN use
     QI == KR*(Q_IN + TV*Q'DOT);
  else
     QI == KR*(Q_IN + 1.0/TN*Q'INTEG + TV*Q'DOT);
  end use;
  Q_OUT ==  QI'SLEW(1.0E10);
end architecture IDEAL;
