-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for A-to-D Converter
-- 
-- Description:
-- A 1 kHz sinusoidal voltage is converted. Signal S_OUT_IDEAL is
-- equal '1' for voltages greater than 0.0 and '0' for voltages
-- less than 0.0. Signal S_OUT_EXTENDED is set to '1' when the
-- voltage crosses 0.25. It is set to '0' when the voltage is less
-- than -0.25. Simulation should run until 3 ms.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    STD_LOGIC_1164
-- WORK                    A2D(IDEAL)
-- WORK                    A2D(EXTENDED)
-- -----------------------------------------------------------
--
-- Source:
-- section6.5.1_a2d/tb/bench.vhd
-- -----------------------------------------------------------


library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.STD_LOGIC_1164.all;
    use IEEE.MATH_REAL.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_A2D of BENCH is
   terminal N_IN           : ELECTRICAL;  --
   signal   S_OUT_IDEAL    : STD_LOGIC;
   signal   S_OUT_EXTENDED : STD_LOGIC;
   quantity V across I through N_IN;  -- input voltage branch
begin

   V == SIN(MATH_2_PI*1.0E3*NOW);

UUT1: entity A2D(IDEAL)
        generic map (LEVEL => 0.0)
        port map (N_IN, S_OUT_IDEAL);

UUT2: entity A2D(EXTENDED)
        generic map (LEVEL => 0.0, HYST => 0.5)
        port map (N_IN, S_OUT_EXTENDED);

end architecture BENCH_A2D;
