-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      D-to-A Converter
-- 
-- Description:
-- The output voltage is set to VHIGH for input signal values
-- of '1' and 'H'. Otherwise it is set to 0.0. The function To_Bit
-- from the package STD_LOGIC_1164 is used for signal conversion.
-- The characteristic of the changes of the output voltage depends
-- on the values of the generic parameters.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    STD_LOGIC_1164
-- -----------------------------------------------------------
--
-- Source:
-- d2a.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.STD_LOGIC_1164.all;

entity D2A is
    generic (VHIGH : REAL := 5.0;  -- high voltage [V] 
             TD_01 : TIME := 0 ns; -- posedge delay [TIME]		
             TD_10 : TIME := 0 ns; -- negedge delay [TIME]
             TRISE : REAL := 0.0;  -- rising time [s]
             TFALL : REAL := 0.0   -- falling time [s]
            );
    port 
     (signal   S_IN  : in STD_LOGIC;   -- input signal
      terminal OUTP  : ELECTRICAL      -- output terminal
     );
begin 
    assert VHIGH > 0.0 and TRISE >= 0.0 and TFALL >= 0.0
       report "ERROR: Wrong parameters."
       severity ERROR;
end entity D2A;

architecture IDEAL of D2A is
   quantity  VOUT across IOUT through OUTP;
   signal    SOUT : REAL  := 0.0;
begin
   SOUT <= VHIGH after TD_01 when To_Bit(S_IN) ='1' else
           0.0   after TD_10;

   VOUT == SOUT'RAMP (TRISE, TFALL);       
end architecture IDEAL;
