-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Lowpass Filter in AC Domain
-- 
-- Description:
-- The frequency characteristics of an analog and digital Bessel
-- lowpass are determined. An AC analysis should be carried out
-- between 10 Hz and 50 kHz (500 points/decade).

-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    LOWPASS(BESSEL_2)
-- WORK                    LOWPASS(BESSEL_2_DIGITAL)
-- -----------------------------------------------------------
--
-- Source:
-- section6.6.1_lowpass_ac/tb/bench.vhd
-- -----------------------------------------------------------


library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;  
    use IEEE.MATH_REAL.all;
    use WORK.all;   -- for UUT1 and UUT2
   
entity BENCH is end entity BENCH;

architecture BENCH_AC of BENCH is
    terminal N_IN      : ELECTRICAL;
    terminal N_ANA_OUT : ELECTRICAL;      -- output analog filter
    terminal N_DIG_OUT : ELECTRICAL;      -- output digital filter
    quantity VIN  across IIN through N_IN;
    quantity V_AC : REAL spectrum 1.0, 0.0;    -- spectrum source
begin
    if DOMAIN /= FREQUENCY_DOMAIN use
       VIN == SIN(MATH_2_PI*1.0E3*NOW);
    else
       VIN == V_AC;
    end use;

UUT1: entity LOWPASS(BESSEL_2) 
       generic map (FC => 2.0E3)
       port map (INP => N_IN, OUTP => N_ANA_OUT);
UUT2: entity LOWPASS(BESSEL_2_DIGITAL) 
       generic map(FC => 2.0E3)
       port map (INP => N_IN, OUTP => N_DIG_OUT);
end architecture BENCH_AC;

