-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     LNA test bench
-- 
-- Description:
-- The test-bench shows how a sine wave signal is amplified
-- and compressed by a low-noise amplifier.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    P_SIN(SINGLE_TONE)
-- WORK                    LNA(RF)
-- WORK                    SINK(A1)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.1_lna/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;


entity BENCH is end BENCH;


architecture TEST_LNA of BENCH is
  constant  FIRST_TONE :  REAL:= -30.0;
  constant  FIRST_FREQ :  REAL:= 1.0e03;
  constant  R_s        :  REAL:=  50.0;   
  constant  POWER_GAIN :  REAL:=   6.0;
  constant  IIP3_POINT :  REAL:= -23.0;
  constant  NOISE_FIG  :  REAL:=   2.5;
  terminal N_INT: ELECTRICAL;
  terminal N_1, N_2, N_VDD: ELECTRICAL;
  quantity V_R2  across I_R2  through N_2;  
  quantity V_VDD across I_VDD through N_VDD;

begin                                          
                  
  V_VDD == 2.7;
                                  
  V_R2 == R_S * I_R2;         
               
  SRC1: entity P_SIN(SINGLE_TONE)
    generic map ( PA_DBM => FIRST_TONE,
                  FREQ   => FIRST_FREQ)   
    port map (P=>N_1, M=>ELECTRICAL_REF);
                         
  LNA1: entity LNA(RF)
    generic map ( GP_DB => POWER_GAIN,
		  IP3_DBM => IIP3_POINT,
		  FNOISE_DB => NOISE_FIG    
		  )
    port map (P_IN=>N_1,
	      P_OUT=>N_2,
	      VDD=>N_VDD,
	      GND=>ELECTRICAL_REF
	      );
                         
  SNK: entity SINK(A1)
    port map (P_IN=>N_1,
	      P_OUT=>N_2,
	      GND=>ELECTRICAL_REF);

end architecture TEST_LNA;

--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


