-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Sink model
-- 
-- Description:
-- This model describes a sink where the power dissipation
-- at a load resistance of R_SINK can be observed as a logarithmic
-- measure.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- -----------------------------------------------------------
--
-- Source:
-- sink.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;

entity SINK is   
  generic (R_SINK: REAL:= 50.0);      
  port (TERMINAL P_IN, P_OUT, GND: ELECTRICAL);
end entity SINK;

                     
architecture A1 of SINK is

  --branch quantities
  quantity V_1   across   P_IN to GND;
  quantity V_2   across   P_OUT to GND;  

  quantity P1_DBM, P2_DBM: REAL;
  
begin
                  
  if abs(V_2)>0.0 and abs(V_1)>0.0 use
    P1_DBM == 10.0*LOG10((V_1*V_1)/R_SINK)+30.0;
    P2_DBM == 10.0*LOG10((V_2*V_2)/R_SINK)+30.0;
  else
    P1_DBM == -200.0;                            
    P2_DBM == -200.0;
  end use;
end architecture A1;

--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


