-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Lowpass filter
-- 
-- Description:
-- This part contains the package with filter functions for
-- the computation of lowpass filter coefficients
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE                    MATH_REAL
-- -----------------------------------------------------------
--
-- Source:
-- filter_functions_body.vhd
-- -----------------------------------------------------------


library IEEE;
  use IEEE.MATH_REAL.all;

package body FILTER is

-- ------------------------------------------------------
-- Coefficients for Butterworth filter
-- ------------------------------------------------------

function LOWPASS_BUTTERWORTH_A (GRAD : INTEGER) 
  return REAL_VECTOR is
  constant NU  : INTEGER := (GRAD+1)/2;
  variable A   : REAL_VECTOR (1 to NU);
begin
  if GRAD mod 2 = 0 then
    for I in 1 to GRAD/2 loop
      A(I) := 2.0*COS((2.0*REAL(I)-1.0)*MATH_PI/2.0/REAL(GRAD));
    end loop;
  else
    A(1) := 1.0;
    for I in 2 to (GRAD+1)/2 loop
      A(I) := 2.0*COS((REAL(I)-1.0)*MATH_PI/REAL(GRAD));
    end loop;
  end if;
  return A;
end function LOWPASS_BUTTERWORTH_A;
 

function LOWPASS_BUTTERWORTH_B (GRAD : INTEGER) 
  return REAL_VECTOR is
  constant NU  : INTEGER := (GRAD+1)/2;
  variable B   : REAL_VECTOR (1 to NU);
begin
  if GRAD mod 2 = 0 then
    for I in 1 to GRAD/2 loop
      B(I) := 1.0;
    end loop;
  else
    B(1) := 0.0;
    for I in 2 to (GRAD+1)/2 loop
      B(I) := 1.0;
    end loop;
  end if;
  return B;
end function LOWPASS_BUTTERWORTH_B;

end package body FILTER;

