-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Filter test bench
-- 
-- Description:
-- The test-bench shows six lowpass filter of varying grade in
-- parallel. In transient and small signal analysis the effects of
-- the different grades can be studied.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    LOWPASS_FILTER(BHV_RF)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.6_lowpass/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;

entity BENCH is 
    constant GAIN     : REAL       := 0.0;
    constant FG       : REAL       := 1.0E4;   
end entity BENCH;

architecture TEST_LOWPASS of BENCH is

    terminal I1, I2, I3, I4, I5, I6: ELECTRICAL;
    terminal O1, O2, O3, O4, O5, O6: ELECTRICAL;
    quantity V1 across IC1 through I1;
    quantity V2 across IC2 through I2;
    quantity V3 across IC3 through I3;
    quantity V4 across IC4 through I4;
    quantity V5 across IC5 through I5;
    quantity V6 across IC6 through I6;
    quantity AC1, AC2, AC3, AC4, AC5, AC6: REAL spectrum 1.0, 0.0;
    signal S1, S2, S3, S4, S5, S6: REAL := 0.0;

    constant ROUT : REAL := 50.0;
    quantity VO1 across IO1 through O1;
    quantity VO2 across IO2 through O2;
    quantity VO3 across IO3 through O3;
    quantity VO4 across IO4 through O4;
    quantity VO5 across IO5 through O5;
    quantity VO6 across IO6 through O6;

BEGIN
      S1  <= 1.0 after 10 NS;
      S2  <= 1.0 after 10 NS;
      S3  <= 1.0 after 10 NS;
      S4  <= 1.0 after 10 NS;
      S5  <= 1.0 after 10 NS;
      S6  <= 1.0 after 10 NS;

      V1 == 1.0*S1'RAMP(1.0E-9, 1.0E-9) + AC1;
UUT1: entity LOWPASS_FILTER (BHV_RF)
             generic map (GAIN, FG, 1)
             port map (I1, ELECTRICAL_REF, O1, ELECTRICAL_REF);

      V2 == 1.0*S2'RAMP(1.0E-9, 1.0E-9) + AC2;
UUT2: entity LOWPASS_FILTER (BHV_RF)
             generic map (GAIN, FG, 2)
             port map (I2, ELECTRICAL_REF, O2, ELECTRICAL_REF);

      V3 == 1.0*S3'RAMP(1.0E-9, 1.0E-9) + AC3;
UUT3: entity LOWPASS_FILTER (BHV_RF)
             generic map (GAIN, FG, 3)
             port map (I3, ELECTRICAL_REF, O3, ELECTRICAL_REF);

      V4 == 1.0*S4'RAMP(1.0E-9, 1.0E-9) + AC4;
UUT4: entity LOWPASS_FILTER (BHV_RF)
             generic map (GAIN, FG, 4)
             port map (I4, ELECTRICAL_REF, O4, ELECTRICAL_REF);

      V5 == 1.0*S5'RAMP(1.0E-9, 1.0E-9) + AC5;
UUT5: entity LOWPASS_FILTER (BHV_RF)
             generic map (GAIN, FG, 5)
             port map (I5, ELECTRICAL_REF, O5, ELECTRICAL_REF);

      V6 == 1.0*S6'RAMP(1.0E-9, 1.0E-9) + AC6;
UUT6: entity LOWPASS_FILTER (BHV_RF)
             generic map (GAIN, FG, 6)
             port map (I6, ELECTRICAL_REF, O6, ELECTRICAL_REF);

--  load resistors
    VO1 == IO1*ROUT;
    VO2 == IO2*ROUT;
    VO3 == IO3*ROUT;
    VO4 == IO4*ROUT;
    VO5 == IO5*ROUT;
    VO6 == IO6*ROUT;

end architecture TEST_LOWPASS;


