-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     A2D test bench
-- 
-- Description:
-- The test-bench shows how a sine wave signal is digitalized
-- and converted back again to analog domain. Since the number
-- of bits for the resolution of the digital signal can be
-- choosen, effects of quantization can be studied.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    P_SIN(SINGLE_TONE)
-- WORK                    A2D(BHV_RF)
-- WORK                    D2A(BHV_RF)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.8_adc/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;


entity BENCH is end BENCH;

architecture TEST_A2D of BENCH is

  constant  IN_TONE    :  REAL:= -30.0;
  constant  IN_FREQ    :  REAL:= 5.0e05;
  constant  SAMPLE_RATE:  REAL:= IN_FREQ*100.0;
  constant  SAMPLE_TIME:  TIME:= 0.5/SAMPLE_RATE*1sec;
  constant  RESOLUTION :  INTEGER:= 4;
  constant  R_S        :  REAL:=  50.0;

  terminal N_A, N_A2: ELECTRICAL;

  quantity V_R2  across I_R2  through N_A2;  

  signal S_BIT: BIT_VECTOR(RESOLUTION-1 downto 0);
  signal S_CLK: BIT:='0';

begin

  process
  begin
    wait for SAMPLE_TIME;
    S_CLK <= not S_CLK;
  end process;
  
  SRC1: entity P_SIN(SINGLE_TONE)
    generic map ( VO => 0.005,
		  PA_DBM => IN_TONE-6.0,
                  FREQ   => IN_FREQ)   
    port map (P=>N_A, M=>ELECTRICAL_REF);
                         
  A2DC: entity A2D(BHV_RF)
    generic map(PMAX_DBM => IN_TONE)
    port map (A=>N_A, GND=> ELECTRICAL_REF,
	      D=>S_BIT, CLK=>S_CLK);
  
  D2AC: entity D2A(BHV_RF)
    generic map(PMAX_DBM => IN_TONE,
		TRISE => 1.0E-10,
		TFALL => 1.0E-10)
    port map (D=>S_BIT, A=>N_A2,
	      GND=> ELECTRICAL_REF);
  
  V_R2 == R_S * I_R2;

end architecture TEST_A2D;
