-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     AWGN test bench
-- 
-- Description:
-- The test-bench shows the effects of additive white Gaussian
-- noise on a transmitted signal. In time domain a noisy signal
-- can be observed. In frequency domain this noise is white
-- up to FS_NOISE at least while in a histogram the Gaussian
-- nature of the distribution is to be seen.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    P_SIN(SINGLE_TONE)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.9_awgn/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;

entity BENCH is end BENCH;

architecture TEST_AWGN of BENCH is

  --constants
  constant  FIRST_TONE :  REAL:= -30.0;
  constant  FIRST_FREQ :  REAL:= 1.0e03;
  constant  SIGTONOISE :  REAL:= 20.0;
  constant  FS_NOISE   :  REAL:= 1.0e06;
  constant  R_s        :  REAL:=  50.0;   

  --terminals
  terminal N_1, N_2, N_VDD: ELECTRICAL;

  --branch quantities
  quantity V_R2  across I_R2  through N_2;
  
begin                                          
                  
  V_R2 == R_S * I_R2;         
               
  SRC1: entity P_SIN(SINGLE_TONE)
    generic map ( PA_DBM => FIRST_TONE,
                  FREQ   => FIRST_FREQ)   
    port map (P=>N_1, M=>ELECTRICAL_REF);

  CHN: entity CHANNEL(AWGN)
    generic map ( PS_DBM => FIRST_TONE,
                  S_TO_N => SIGTONOISE,
		  FS_NOISE => FS_NOISE)   
    port map (P_IN=>N_1, P_OUT=>N_2);
                        
end architecture TEST_AWGN;

