-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Peak detector
-- 
-- Description:
-- The output voltage equals the positive peak voltage at the
-- controlling terminal.
--
-- Literature:
-- Conelly, J.A.; Choi, P.: Macromodeling with SPICE.
-- Englewood Cliffs: Prentice Hall, 1992.
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- peakdetector.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity PEAKDETECTOR is
  port (terminal INP  : ELECTRICAL;    -- input pin
	terminal OUTP : ELECTRICAL     -- output pin
	  );
end entity PEAKDETECTOR;

architecture IDEAL of PEAKDETECTOR is
  quantity VIN  across              INP;
  quantity VOUT across IOUT through OUTP;
begin

  VOUT == VIN'SLEW(REAL'HIGH, -1.0E-38);

end architecture IDEAL;
