-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Peak Detector
-- 
-- Description:
-- The voltage at node N2 follows the positive peaks of the
-- voltage at node N1. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    PEAKDETECTOR(IDEAL)
-- -----------------------------------------------------------
--
-- Source:
-- section7.4.1_peak/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;

entity BENCH is end entity BENCH;


architecture PEAK of BENCH is

    terminal N1, N2     : ELECTRICAL;
    quantity VIN across IIN through N1;
    constant AMP : REAL := 1.0;
    constant A   : REAL := 1.0E3;
    constant F   : REAL := 1.0E3;

begin

     VIN == AMP*EXP(A*NOW)*SIN(MATH_2_PI*F*NOW);
UUT: entity PEAKDETECTOR(IDEAL)
       port map (INP => N1, OUTP => N2);

end architecture PEAK;
