-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     OpAmp test bench
-- 
-- Description:
-- The test-bench shows how the gain of an operational amplifier
-- can be controlled by a feedback circuit. The second architecture
-- is used to examine the small signal behavior of the OpAmp.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    OPAMP(MACRO)
-- -----------------------------------------------------------
--
-- Source:
-- section8.4_opamp/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all; 
  use WORK.all;

entity BENCH is end entity BENCH;

architecture FEEDBACK of BENCH is
  terminal N_IN, N_M, N_OUT : ELECTRICAL;
  quantity V_IN across I_IN through N_IN;
  quantity V_R1 across I_R1 through N_IN to N_M;
  quantity V_R2 across I_R2 through N_M to N_OUT;
  quantity V_R3 across I_R3 through N_OUT;
  constant AMPL    : REAL := 12.0;    -- input amplitude
  constant FREQ    : REAL := 1000.0;  -- input frequency
  constant R1      : REAL := 10.0E3;  -- input resistance
  constant R2      : REAL := 20.0E3;  -- feedback resitance
  constant R3      : REAL := 10.0E3;  -- load resistance
  constant A       : REAL := 1.0e5;   -- gain

begin
UUT: entity OPAMP(MACRO)
       port map (INP => ELECTRICAL_REF,
		 INM => N_M,
 		 OUTP => N_OUT);
  V_IN == AMPL * SIN(2.0*MATH_PI*FREQ*NOW);
  V_R1 == R1 * I_R1;
  V_R2 == R2 * I_R2;
  V_R3 == R3 * I_R3;
end architecture FEEDBACK;

architecture AC of BENCH is
  terminal N_IN, N_OUT : ELECTRICAL;
  quantity V_IN across I_IN through N_IN;
  quantity AC : REAL spectrum 1.0, 0.0;

begin
UUT: entity OPAMP(MACRO) 
       port map (INP => ELECTRICAL_REF,
		 INM => N_IN,
                 OUTP => N_OUT);
  V_IN == AC;
end architecture AC;
