%------------------------------------------
%  Demonstration of stability guaranteed horizons 
%------------------------------------------

clc;
clear all;

%------------------------
% System parameters
%------------------------
disp( 'System parameters' );
A = [0 3; -4 5] 
B = [2; 2] 
Q = [1.3 0;0 1.4] 
R = 0.1 
Qf = zeros(size(A,1)) 

%------------------------
% Hamiltonian matrix for the Ac
%------------------------

HF = [A+B*inv(R)*B'*inv(A')*Q    -B*inv(R)*B'*inv(A');         -inv(A')*Q                    inv(A')];
HB = [  inv(A)          inv(A)*B*inv(R)*B' ;         Q*inv(A)     A'+Q*inv(A)*B*inv(R)*B'];

EigHF = eig(HF);
EigHB = eig(HB);
BB = B*inv(R)*B';
EigBB = eig(BB);
x0 = [-2;3];

sizeofeig = size(EigHF);
eigofAc=[];
for i=1:1:sizeofeig
    if(abs(EigHF(i))<1)
        eigofAc=[eigofAc;EigHF(i)];
    end
end

rho_Ac = max(eigofAc);
sizeofEigBB = size(EigBB);
rho_BB=0;

for i=1:1:sizeofEigBB
    if(abs(EigBB(i))>rho_BB)
        rho_BB = EigBB(i);
    end
end

[rho_p1, rho_p2,p]= boundofp(A,B,Q);

epsilon = 1/ rho_Ac -1-0.1 ;
epsilon = 0 ;
epsilon = 1/ rho_Ac -1-0.1 ;

N1=log((1/rho_Ac-1-epsilon)/(rho_BB*rho_p1))/(2*log(rho_Ac))+1 ; 
N2=log((1/rho_Ac-1-epsilon)/(rho_BB*rho_p2))/(2*log(rho_Ac))+1 ;
BB2 = B*inv(R+B'*p*B)*B' ;
EigBB2 = eig(BB2) ;
sizeofEigBB2 = size(EigBB2);
rho_BB2=0;
for i=1:1:sizeofEigBB2
    if(abs(EigBB2(i))>rho_BB2)
        rho_BB2 = EigBB2(i);
    end
end

[nn, mm] = size(A);
kk = 0.00787;
invV=[1/kk 0; 2/kk 1/0.0787];

CM = ctrb(A,B);
SizeCM = size(CM);
RowCM = SizeCM(1);
invCM = inv(CM);
pM = invCM(RowCM,:);
MidMat = pM;
invT=[];
NN = size(A);
n = NN(1);
for i=1:1:n
	MidMat = MidMat*A^(i-1) ;
	invT=[invT; MidMat] ;
end 
 
invV = invT;
V= inv(invV);

A_bar = invV*A*V;
B_bar = invV*B;
Q_bar = V'*Q*V;

X =[100 0; 0 1];
M = [10 0; 0 1];
AA =inv(M)*A_bar*M;
BB= inv(M)*B_bar;
QQ= M*Q_bar*M;

right = [AA*AA'-eye(nn)  AA*sqrt(QQ) ; sqrt(QQ)*AA' QQ];
sizeBB = size(BB);
sizeBB_Col = sizeBB(2);
sizeBB_Row = sizeBB(1);

left = [BB zeros(sizeBB_Row, nn) ; zeros(nn, sizeBB_Col) eye(nn)] ;
alpha = max(abs(eig(inv(left'*left)*left'*right*left*inv(left'*left))))+1 ;
P_bar = A_bar'*inv(1/alpha*M*M+B_bar*B_bar')*A_bar+Q_bar ;

P = inv(V')*P_bar*inv(V) ;

rhoP = max(eig(P)) ;
epsilon = 0.1 ;
N41=log((1/abs(rho_Ac)-1-epsilon)/(rho_BB*rhoP))/(2*log(abs(rho_Ac)))+1 ;
Horizon = N41 ;
sprintf (' Horizon >=  %0.5g',  Horizon )
