function  [B_tilde , C_tilde , G_tilde , H_mtx ]  = MakeBigMatrices_gen(A,B,C,G,Q,R,horizon);

%
%	This function computes big matrices for designing an FIR filter. 
%
% 		
%   Model :    x_{k+1} = A x_k +  G w_k  
%                   y_k = C x_k + v_k
%   		    E[w_k w_k'] = Q    ,    E[v_k v_k'] = R  	
%
%   This function works even for a singular matrix A. 
%

if B == 0
   IsInput = 0 ;
end 

B_tilde = 0 ;
C_tilde = C ;
BM_tilde = C*B ;
GM_tilde = C*G ;
G_tilde = 0 ;

Q_stack = Q ;
R_stack = R ;
A_i = A ;
AG_h = G ;
AB_h = B ;

%-------------------------
%  Parameter setting
%-------------------------
N_input = size(B,2);
N_output = size(C,1);
N_system_noise = size(G,2);
N_order = size(A,1);

%-------------------------
%  Main procedure for augmenting matrices
%-------------------------
for i = 2 : horizon
	if i==2
		if IsInput == 1 
         		B_tilde = [zeros(N_input+size(C*B,2),size(C*B,1))' ; C*B zeros(N_output,size(C*B,2))];
      	end
      	G_tilde = [zeros(N_system_noise+size(C*G,2),size(C*G,1))'; C*G zeros(N_output,size(C*G,2))];
	else
      	if IsInput == 1 
         		B_tilde = [ B_tilde  zeros(size(B_tilde,1),size(C*B,2)); BM_tilde zeros(size(BM_tilde,1),size(C*B,2))];
      	end
	   	G_tilde = [ G_tilde  zeros(size(G_tilde,1),size(C*G,2)); GM_tilde zeros(size(GM_tilde,1),size(C*G,2))];   
      end
   	C_tilde = [C_tilde; C*A_i];
	BM_tilde = [ C*A_i*B BM_tilde];
	GM_tilde = [ C*A_i*G GM_tilde];
   	if i <=  horizon
		AG_h = [A_i*G AG_h];
	end
   	A_i = A_i * A ;
   
	Q_stack = daug(Q_stack,Q);   
   	R_stack = daug(R_stack,R); 
   	B_s = size(B_tilde);
	G_s = size(G_tilde);
   	Q_s = size(Q_stack);
   	R_s = size(R_stack);
end
size(G_tilde);
size(G_tilde');
size(Q_stack);
size(R_stack);
PPi = G_tilde * Q_stack *G_tilde' + R_stack ;
G_matrix = AG_h ;

X_1 = Q_stack*G_tilde'*inv(PPi)*(eye(size(C_tilde*inv(C_tilde'*inv(PPi)*C_tilde)*C_tilde'*inv(PPi))) - C_tilde*inv(C_tilde'*inv(PPi)*C_tilde)*C_tilde'*inv(PPi)) ;
A_final = A^horizon ;
X_2 = inv(C_tilde'*inv(PPi)*C_tilde)*C_tilde'*inv(PPi) ;
H_mtx = G_matrix * X_1 + A_final * X_2 ;