function region = mas(A,Phi,phi,t_star)
%
% This program computes the contour defining the Maximal Admissible Set  O_inf
% mas is the acronym for Maximal Admissible Set
%
% Syntax : region = mas(A , Phi , phi , t_star )
% 
% O_inf is defined as follows: 
%
%     O_inf = {x| Phi*A^k*x <= phi, k=0,1,.... }
%

error(nargchk(4,4,nargin));
[mA,nA]=size(A);

%% Error check for matrix A
if(mA~=nA) 
   error('Matrix A should be square.');
end

if(mA~=2)  
   error('Matrix A should be 2-by-2.');
end

%% Error check for matrix Phi and phi
[mPhi,nPhi] = size(Phi);
if(nPhi~=mA)
   error('Dimension mismach between A and Phi');
end

[mphi, nphi] = size(phi);
if(nphi~=1)
   error('phi should be a vector, not matrix');
end

if(mPhi~=mphi)
   error('Phi and phi should have same number of rows.');
end   

%% Error check for t_star
if((t_star<0)|(t_star-floor(t_star)))
   error('t_star should be a non-negative integer.');
end


ConMtx =[];     %% Constraint-defining Matrix
ConVect  = [];  %% Constraint-defining Vector
for i=0:1:t_star,
   ConMtx =[ConMtx;Phi*A^i];
   ConVect=[ConVect;phi];
end

[row,col]=size(ConMtx);
regionTmp =[];

%% Basically, O_inf is a polytope. Therefore it is defined by 
%% the lines. We will obtain the intersections of two lines and then
%% we will check whether the intersection is on the contour of O_inf
for i=1:row-1
   for k=i+1:row
      tmpMtx = [ConMtx(i,:);ConMtx(k,:)];
      tmpVect = [ConVect(i);ConVect(k)];
      if(abs(det(tmpMtx))>0.00001)  %% If there exists an inverse
         x = inv(tmpMtx)*tmpVect;
         diff = ConVect-ConMtx*x;
         if(min(diff)>=0)           %% Check the intersection is on the contour of O_inf   
            regionTmp = [regionTmp x];
         end
      end
   end
end


%% From now, we will sort the intersections such that we can draw the contour of O_inf
%% Sorting will be done using the magnitude of the angle of the intersection 
[row,col]= size(regionTmp);
Ang =[];
for i=1:col
    Ang = [Ang ; mod(angle(regionTmp(1,i)+j*regionTmp(2,i)), 2*pi)];
end

[Ang, indx] = sort(Ang);
region = [];
for i=1:col
   region = [region regionTmp(:,indx(i))];
end
region = [region region(:,1)];


