function  [H_mtx , L_mtx ]  = fmc ( A , B , C , G , Q , R , Q_f , Q_w , R_v , F_horizon , C_horizon ) ;

%
%	This function computes coefficients of the finite memory control.
%
% 		
%   Model :    x_{k+1} = A x_k + B u_k + G w_k  
%                   y_k = C x_k + v_k
%   		    E[w_k w_k'] = Q_w    ,    E[v_k v_k'] = R_v  	
%  
%  
%   Performance criterion for FMC : 
%		      \ sum_{i=0}^{C_horizon -1}  [   x_{k+i}' Q x_{k+i} +  u_{k+i}' R u_{k+i}  ] + x_{k+C_horizon}' Q_f x_{k+C_horizon}
%
%   FMC structure :
%	            \ u_{k} = \sum_{i=1}^{F_horizon} H_i y_{k-F_horizon-1+i}   +  \sum_{i=1}^{F_horizon} L_i u_{k-F_horizon-1+i}
%
%
%   Input parameters
%  			A , B , C , G  		: 		System parameters
%               Q , R , Q_f    		:	 	Weighting matrices for cost function 
%               Q_w , R_v    		: 		Noise covariances for Kalman filter           
%               F_horizon , C_horizon  	:        Horizons for controls and filters 
%

%-------------------------
%  Variables for big matrices
%-------------------------

B_tilde = 0;
C_tilde = C;
BM_tilde = C*B;
GM_tilde = C*G;
G_tilde = 0;
Q_stack = Q_w ;
R_stack = R_v ;
A_i = A;
AG_h = G;	
AB_h = B;

%-------------------------
%  Dimensions
%-------------------------

N_input = size(B,2);
N_output = size(C,1);
N_system_noise = size(G,2);
N_order = size(A,1);


%-------------------------
%  Compute an RHC gain
%-------------------------
K_i = Q_f ;
for i=1 : C_horizon-1
   K_i = A'*K_i*inv(eye(N_order)+B*inv(R)*B'*K_i)*A + Q ;
end

%-------------------------
%  Main procedure
%-------------------------
for i = 2 : F_horizon
	if i==2
		B_tilde = [zeros(N_input+size(C*B,2),size(C*B,1))' ; C*B zeros(N_output,size(C*B,2))];
		G_tilde = [zeros(N_system_noise+size(C*G,2),size(C*G,1))'; C*G zeros(N_output,size(C*G,2))];
	else
		B_tilde = [ B_tilde  zeros(size(B_tilde,1),size(C*B,2)); BM_tilde zeros(size(BM_tilde,1),size(C*B,2))];      
		G_tilde = [ G_tilde  zeros(size(G_tilde,1),size(C*G,2)); GM_tilde zeros(size(GM_tilde,1),size(C*G,2))];   
	end
	C_tilde = [C_tilde; C*A_i];
   	BM_tilde = [ C*A_i*B BM_tilde];
   	GM_tilde = [ C*A_i*G GM_tilde];
   
   	if i <=  F_horizon
      	j = i ;
      	AG_h = [A_i*G AG_h];
   	end
   	A_i = A_i * A ;
	Q_stack = daug(Q_stack,Q_w);   
	R_stack = daug(R_stack,R_v); 
	B_s = size(B_tilde);
	G_s = size(G_tilde);
	Q_s = size(Q_stack);
	R_s = size(R_stack);
end
PPi = G_tilde * Q_stack * G_tilde' + R_stack ;
inv(PPi) ;
G_matrix = AG_h;

X_1 = Q_stack*G_tilde'*inv(PPi)*(eye(size(C_tilde*inv(C_tilde'*inv(PPi)*C_tilde)*C_tilde'*inv(PPi))) - C_tilde*inv(C_tilde'*inv(PPi)*C_tilde)*C_tilde'*inv(PPi));
A_final = A^F_horizon ;
X_2 = inv(C_tilde'*inv(PPi)*C_tilde)*C_tilde'*inv(PPi);
H_mtx = G_matrix*X_1+A_final*X_2 ;
A_N =B;
for i=1:F_horizon-1,
   A_N = [ A*A_N B ];
end
L_mtx = -H_mtx*B_tilde + A_N;

%-------------------------
% Combining an RHC with an FIR filter 
%-------------------------

H_mtx = - inv(R)*B'* inv(  eye(N_order) + K_i * B * R^(-1) * B' )* K_i * H_mtx ;
L_mtx = - R^(-1)*B'* inv(  eye(N_order) + K_i * B * R^(-1) * B' )* K_i  * L_mtx ;
 