%------------------------------------------
%  Demonstration of RHC using LMI
%------------------------------------------
clear all;

%% System State Equation
A= [1     0.2212 ;
    0     0.7788];
B = [0.0288;0.2212];
G =[1 0; 0 1; 1.5 1];

%% Initial State
x0 = [1 ; 0.3];  
[n,n]=size(A);
[n,m]=size(B);

%-------------------------
%  Let's get horizon and simulation time 
%-------------------------
N = input('Horizon N =' ) ;
length = input('Total simulation time =') ;

%------------------------
% Input Constraint
%------------------------
u_lim=0.5;
ubar_lim = [];
for i=1:N,
   ubar_lim=[ubar_lim;u_lim];
end


%------------------------
% State Constraint
%------------------------
x_lim = [1.5;0.3];
G =[1  0;
       0  1];
g_lim = [1.5; 0.3];
gbar_lim = [];
for i=1:N,
   gbar_lim=[gbar_lim;g_lim];
end

 
[ng_r, ng_c] = size(G);

%------------------------
% Weighting Matrices
%------------------------
Q = 1*eye(size(A));
R = 1;


A_hat=[];
B_hat=[];
for i=1:N-1,
   A_hat = daug(A_hat, A);
   B_hat = daug(B_hat, B);
end
A_hat = [zeros(n,n*N);
        A_hat zeros(n*(N-1),n)];
B_hat = [zeros(n,m*N);
        B_hat zeros(n*(N-1),m)];           
W_hat = inv(eye(n*N)-A_hat)*B_hat;
V0_hat = inv(eye(n*N)-A_hat)*[x0;zeros(n*(N-1),1)];      

B_bar=[];
for i=1:N,
   B_bar = [B_bar A^(N-i)*B];
end

%-----------------------------------------
% Let's get stacked weighting matrices
%-----------------------------------------
[m,n]=size(Q);
[p,q] = size(R);
Q_hat = [];
R_hat = [];
for i=1:N,
   Q_hat = daug(Q_hat, Q);
   R_hat = daug(R_hat, R);
end

%--------------------------
% Let's get constraint matrices
%--------------------------
G_bar = [];
for i=1:N
   G_bar = daug(G_bar, G);
end   

W=W_hat'*Q_hat*W_hat + R_hat;
W=(W+W')/2;

%-------------------------------
%  Simulation starts !
%-------------------------------
t= [];
State = [];
U = []; 
summed_cost=0;
Summed_cost=[];
Cost_at_k=[];
x = x0;

R1=[];
R2=[];
for i=0:(length-1),
    sprintf(' Time : %d ', i );
    V0_hat = inv(eye(n*N)-A_hat)*[x;zeros(n*(N-1),1)];
    V = 2*W_hat'*Q_hat*V0_hat;
    V0 = V0_hat'*Q_hat*V0_hat;
    
    %% Solve LMI
    [X,Y,r1,r2,opt_u] = rhc_lmi(x,N,A,B,Q,R,W_hat,V0_hat,Q_hat,B_bar,W,V,V0,G,G_bar,ubar_lim,gbar_lim,u_lim,g_lim);
    P = r2*inv(X);
    
    if (i==0),
        boundary0=[];
        for th=0:0.01:2*pi,
            z  = sqrt(r2)*inv(P^0.5)*[cos(th);sin(th)];
            boundary0=[boundary0  z];
        end
    elseif(i==1),
        boundary1=[];
        for th=0:0.01:2*pi,
           z = sqrt(r2)*inv(P^0.5)*[cos(th);sin(th)];
           boundary1=[boundary1  z];
        end
    elseif(i==2),
        boundary2=[];
        for th=0:0.01:2*pi,
            z = sqrt(r2)*inv(P^0.5)*[cos(th);sin(th)];
            boundary2=[boundary2  z];
        end 
    elseif(i==3),
        boundary3=[];
        for th=0:0.01:2*pi,
            z = sqrt(r2)*inv(P^0.5)*[cos(th);sin(th)];
            boundary3=[boundary3  z];
        end 
    elseif(i==4),
        boundary4=[];
        for th=0:0.01:2*pi,
            z = sqrt(r2)*inv(P^0.5)*[cos(th);sin(th)];
            boundary4=[boundary4  z];
        end 
    end
                
    K = Y*inv(X);
    u = opt_u(1);
    State = [State x];
    
    %% Control Input 
    U = [U u]; 
    
    cost_at_k = r1+r2;
    real_cost = x'*Q*x + u'*R*u;
    R1=[R1 r1];
    R2=[R2 r2];
    summed_cost = summed_cost + real_cost;
    Cost_at_k = [Cost_at_k cost_at_k];
    Summed_cost = [Summed_cost summed_cost];
    
    %-------------------
    %  State Update
    %-------------------
    x = A*x + B*u;
    t= [t i+1];
    home;
end

Cost_at_k=[Cost_at_k Cost_at_k(length)];
Summed_cost=[Summed_cost Summed_cost(length)];
U=[U u];
State=[State x];
t=[ 0 t];R2=[R2 R2(length)];R1=[R1 R1(length)];

%--------------------------------------
% Let's take a look at the simulation results
%--------------------------------------
figure;
plot(t,State(1,:),'r:',t,State(2,:),'b');
legend('x1','x2',0);
xlabel('Time');grid;
title('States');

if (i>5),
figure;
plot(State(1,:),State(2,:),'o',boundary0(1,:),boundary0(2,:),'b', boundary1(1,:),boundary1(2,:),'r',...
   boundary2(1,:),boundary2(2,:),'k',boundary3(1,:),boundary3(2,:),'r',boundary4(1,:),boundary4(2,:),'r');
axis([-1.7 1.7 -0.35 0.35]);
title('Invariant ellipsoids and state trajectories');
end

figure;
stairs(t,U);
xlabel('Time');grid;
title('Control input');

figure;
stairs(t,Cost_at_k,'r');
xlabel('Time');grid;
title('Expected cost at time k');

figure;
stairs( t , Summed_cost , 'b' );grid;
xlabel('Time');
title('Summed cost');
