#!/usr/bin/env python

# (c) 2005 Springer Science+Business Media, Inc.
#
# This electronic component package is protected by federal copyright
# law and international treaty. If you wish to return this book and the
# CD-ROM disc to Springer, do not open the disc envelope or remove it
# from the book. Springer will not accept any returns if the package has
# been opened and/or separated from the book. The copyright holder
# retains title to and ownership of the package. U.S. copyright law
# prohibits you from making any copy of the entire CD-ROM for any reason
# without the written permission of Springer.
#
# Springer or the author(s) makes no warranty or representation, either
# express or implied, with respect to this CD-ROM or book, including
# their quality, merchantability, or fitness for a particular
# purpose. In no event will Springer or the author(s) be liable for
# direct, indirect, special, incidental, or consequential damages
# arising out of the use or inability to use the disc or book, even if
# Springer or the author(s) has been advised of the possibility of such
# damages.

# python hexarray object 

from Hexint import Hexint
import math

class Hexarray:

    def __init__( self, size ):
        self.nhexs = 7**size
        self.hexdata = [ 0 ]*self.nhexs
        self.layers = size

    def __str__( self ):
        output = '<'
        for i in self.hexdata:
            output += str(i)+', '
        output += '>'
        return output

    __repr__ = __str__

    def __len__( self ):
        return self.nhexs

    def __getitem__( self, pos ):
        if isinstance( pos, Hexint ):
            p = pos.getInt()
        else:
            p = pos
        return self.hexdata[p]

    def __setitem__( self, pos, value ):
        if isinstance( pos, Hexint ):
            p = pos.getInt()
        else:
            p = pos
        self.hexdata[p] = value
            
    def __getslice__( self, low,high ):
        if isinstance( low, Hexint ) and isinstance(high,Hexint):
            p1,p2 = low.getInt(), high.getInt()
        else:
            p1,p2 = low,high
        return self.hexdata[low:high]

    def __setslice__( self, low,high, values ):
        if isinstance( low, Hexint ) and isinstance(high,Hexint):
            p1,p2 = low.getInt(), high.getInt()
        else:
            p1,p2 = low,high
        self.hexdata[low:high] = values

    def getLayers( self ):
        return self.layers

    def save( self, filename ):
        data = open( filename, 'w' )
        output = self.getXML( )
        data.write( output )
        data.close( )

    def getXML( self ):
        data = ''
        cmplxflag = False
        tupleflag = False
        if isinstance(self.hexdata[0],int):
            dname = 'int'
        elif isinstance(self.hexdata[0],float):
            dname = 'double'
        elif isinstance(self.hexdata[0],complex):
            dname = 'complex'
            cmplxflag = True
        elif isinstance(self.hexdata[0],tuple):
            dname = 'rgb'
            tupleflag = True
        data += '<struct>\n' 
        data += '<member>\n'
        data += '<name>layers</name>\n'
        data += '<value><int>%d</int></value>\n'%self.layers
        data += '</member>\n'
        data += '<member>\n'
        data += '<name>datatype</name>\n'
        data += '<value><string>%s</string></value>\n'%dname
        data += '</member>\n'
        data += '</struct>\n'
        data += '<array>\n'
        data += '<data>\n'
        for i in self.hexdata:
            if cmplxflag==True:
                data += '<value><%s>%d,%d</%s></value>\n' \
                        % (dname,i.real,i.imag,dname)
            else:
                if tupleflag==True:
                    data += '<value><%s>%d,%d,%d</%s></value>\n' % (dname,i[0],i[1],i[2],dname)
                else:
                    data += '<value><%s>%d</%s></value>\n'%(dname,i,dname)
        data += '</data>\n'
        data += '</array>\n'

        return data


# testing of the preprocess object
if __name__ == '__main__':
    h = Hexarray(1)
    h
    for i in range(len(h)):
        h[i] = i
    h
    h[Hexint(3)]=42
    h
    h.getLayers()

