/* Program to perform median filtering on the bitmap image */

#include<stdio.h>
#include<conio.h>
#include<stdlib.h>
#include<io.h>

/* The following function reads the first 54 bytes of the bitmap 
   image which constitutes its header */

void header_detatch(FILE *fpt,int y[])
{  int i;
   for(i=0;i<54;i++)  
      y[i]=getc(fpt);
   return;
}

/* The following function does median filtering on the raw image */

void process_image(FILE *fpt,FILE *fp,FILE *newfile,int y[])
{  int w1,w2,w,h1,h2,h,e,f,s1,s2,s3;
   int i,j,x[8][3];
   long s; 
   w1=y[18];    // w2 and w1 are the most significant and least significant bytes respectively
   w2=y[19];    // of w
   w=(w2*256+w1);
   e=(4-3*w%4);
    if(e==4)
       e=0; 
   h1=y[22];
   h2=y[23];
   h=(h2*256+h1);
   w=w-2;
   f=(4-3*w%4);
    if(f==4)
       f=0; 
   w1=w%256;
   w2=(w-w1)/256;   
   y[18]=w1;
   y[19]=w2;
   h=h-2;
   h1=h%256;
   h2=(h-h1)/256;
   y[22]=h1;
   y[23]=h2;
   s=0X36+h*(3*w+f);
   s1=s%256;
   s2=((s-s1)%65536)/256;
   s3=s/65536;
   y[2]=s1;
   y[3]=s2;
   y[4]=s3;
   s=s-0X36;
   s1=s%256;
   s2=((s-s1)%65536)/256;
   s3=s/65536;
   y[34]=s1;
   y[35]=s2;
   y[36]=s3;
   fseek(fp,54,0);
   fseek(newfile,54,0);
   for(i=0;i<h;i++)
    {  for(j=0;j<w;j++)
	 {  fseek(fpt,ftell(fp),0);
 x[0][0]=getc(fpt);x[0][1]=getc(fpt); x[0][2]=getc(fpt);
 x[1][0]=getc(fpt);x[1][1]=getc(fpt); x[1][2]=getc(fpt);
x[2][0]=getc(fpt);x[2][1]=getc(fpt); x[2][2]=getc(fpt);
 fseek(fpt,3*(w-1)+e,1);
 x[3][0]=getc(fpt);x[3][1]=getc(fpt); x[3][2]=getc(fpt);
 fseek(fpt,3,1);
 x[4][0]=getc(fpt);x[4][1]=getc(fpt); x[4][2]=getc(fpt);
 fseek(fpt,3*(w-1)+e,1);
 x[5][0]=getc(fpt);x[5][1]=getc(fpt); x[5][2]=getc(fpt);
x[6][0]=getc(fpt);x[6][1]=getc(fpt); x[6][2]=getc(fpt);
x[7][0]=getc(fpt);x[7][1]=getc(fpt); x[7][2]=getc(fpt);

  for(w1=0;w1<8;w1++)
for(w2=0;w2<3;w2++)
 if(x[w1][w2]<0)
  { printf("\n -ve value encountered at row=%d  column=%d",i+1,j+1); getch();  }
   for(w1=0;w1<3;w1++)
   { for(w2=0;w2<7;w2++)
     { for(h1=w2+1;h1<8;h1++)
	if(x[h1][w1]<x[w2][w1])
	{  h2=x[h1][w1];
	   x[h1][w1]=x[w2][w1];
	   x[w2][w1]=h2;
	 }
      }
    }
	   putc(x[4][0],newfile);
	   putc(x[4][1],newfile);
	   putc(x[4][2],newfile);
	   fseek(fp,3,1);

      }
        for(w1=0;w1<f;w1++)
	    putc(0X00,newfile);
	fseek(fp,6+e,1);
	   
    }

    return;
}


void header_attach(FILE *newfile,int y[])
{  int i;
   fseek(newfile,0,0);
   for(i=0;i<54;i++)  
   putc(y[i],newfile);
   return;
}


void main()
{  FILE *fpt,*newfile,*fp;
   int y[54];
 
   fp=fopen("pic.bmp","r"); 
   fpt=fopen("pic.bmp","r");
   
   newfile=fopen("med_fil.bmp","w+");
   header_detatch(fpt,y);
   process_image(fpt,fp,newfile,y);
   header_attach(newfile,y);
   fclose(fp);
   fclose(fpt);
   fclose(newfile);
   printf("\n Picture conversion successfull.\nThe input file is pic.bmp\nThe output file is med_fil.bmp\n"); 
   getch();
}
/* end of programme */

