/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp.awt;

import hydro.awt.Taste;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public final class Tastatur
extends Container
implements feu.mrp.Tastatur {
    static final int PRESS_MASK = 8;
    static char[] charcode = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'c', 'd', 'e', 'f', '\u0000', '\u0000', '8', '9', 'a', 'b', '\u0000', '\u0000', '4', '5', '6', '7', '\u0000', '\u0000', '0', '1', '2', '3', '+', '-'};
    static int[] keycode = new int[]{84, 112, 113, 114, 115, 67, 0, 0, 0, 0, 83, 76, 0, 0, 0, 0, 82, 71, 0, 0, 0, 0, 65, 68, 0, 0, 0, 0, 107, 109};
    static int[] modifiers = new int[]{2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0};
    static Color[] backs = new Color[]{Color.darkGray, Color.darkGray, Color.darkGray, Color.darkGray, Color.darkGray, Color.black, Color.black, Color.black, Color.black, Color.black, Color.darkGray, Color.darkGray, Color.black, Color.black, Color.black, Color.black, Color.darkGray, Color.darkGray, Color.black, Color.black, Color.black, Color.black, Color.darkGray, Color.darkGray, Color.black, Color.black, Color.black, Color.black, Color.darkGray, Color.darkGray};
    private KeyListener keyListener;
    private ActionListener actionListener;
    private CollectAction collector;
    private Taste[] tasten;

    public final boolean getReset() {
        return this.tasten[5].getPressed();
    }

    public final boolean getF4() {
        return this.tasten[4].getPressed();
    }

    public final byte getSpalte(int n) {
        byte by = -16;
        if (n >= 0 && n < 7) {
            int n2 = 0;
            while (n2 < 4) {
                if (this.tasten[feu.mrp.Tastatur.matrix[n][n2]].getPressed()) {
                    by = (byte)(by + (1 << n2));
                }
                ++n2;
            }
        }
        return by;
    }

    public static final int commandToSpalte(String string) {
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 4) {
                if (feu.mrp.Tastatur.comm[feu.mrp.Tastatur.matrix[n][n2]].equals(string)) {
                    return n;
                }
                ++n2;
            }
            ++n;
        }
        return -1;
    }

    public final boolean isFocusTraversable() {
        return true;
    }

    protected final void doKeyEvent(KeyEvent keyEvent) {
        int n = 0;
        while (n < 30) {
            if (charcode[n] != '\u0000' && !keyEvent.isActionKey() && keyEvent.getKeyChar() == charcode[n]) {
                this.keyAction(n, keyEvent);
                return;
            }
            if (keycode[n] != 0 && keycode[n] == keyEvent.getKeyCode() && modifiers[n] == (keyEvent.getModifiers() & 0xFFFFFFF7)) {
                this.keyAction(n, keyEvent);
                return;
            }
            ++n;
        }
    }

    protected final void keyAction(int n, KeyEvent keyEvent) {
        Taste taste = this.tasten[n];
        if ((keyEvent.getModifiers() & 8) == 0) {
            if (keyEvent.getID() == 401) {
                taste.setPressed(true);
            } else {
                taste.setPressed(false);
                taste.setPermanent(false);
            }
            taste.processAction();
        } else if (keyEvent.getID() == 402) {
            if (taste.getPermanent()) {
                taste.setPermanent(false);
            } else {
                taste.setPermanent(true);
            }
            taste.processAction();
        }
        keyEvent.consume();
    }

    public final void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    /* synthetic */ ActionListener access$0() {
        return this.actionListener;
    }

    public Tastatur() {
        this.setBackground(Color.black);
        this.setLayout(new GridLayout(5, 6));
        Tastatur tastatur = this;
        if (tastatur == null) {
            throw null;
        }
        this.collector = tastatur.new CollectAction();
        this.tasten = new Taste[30];
        int n = 0;
        while (n < 30) {
            Taste taste = new Taste(feu.mrp.Tastatur.titel[n]);
            this.add(taste);
            taste.setBackground(backs[n]);
            taste.setActionCommand(feu.mrp.Tastatur.comm[n]);
            taste.setFontFactor(50);
            taste.setRectFactor(5);
            taste.addActionListener(this.collector);
            this.tasten[n] = taste;
            ++n;
        }
        Tastatur tastatur2 = this;
        if (tastatur2 == null) {
            throw null;
        }
        this.keyListener = tastatur2.new TastaturKeyListener();
        this.addKeyListener(this.keyListener);
        this.requestFocus();
    }

    final class TastaturKeyListener
    extends KeyAdapter {
        public final void keyPressed(KeyEvent keyEvent) {
            Tastatur.this.doKeyEvent(keyEvent);
        }

        public final void keyReleased(KeyEvent keyEvent) {
            Tastatur.this.doKeyEvent(keyEvent);
        }

        TastaturKeyListener() {
        }
    }

    final class CollectAction
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            if (Tastatur.this.access$0() != null) {
                Tastatur.this.access$0().actionPerformed(new ActionEvent(Tastatur.this, actionEvent.getID(), actionEvent.getActionCommand()));
            }
        }

        CollectAction() {
        }
    }
}

