/*
 * Decompiled with CFR 0.152.
 */
package feu.tastatur;

import feu.mrp.awt.Rechner;
import feu.tastatur.TastaturDraw;
import hydro.awt.Hawt;
import hydro.awt.Hframe;
import hydro.awt.Hgrid;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;

public class Tastatur
extends Hframe
implements ActionListener {
    public static Tastatur mainWindow;
    public static final String MSGVER = "v0.08";
    public static final String MSGJVM;
    static final String MI_REDRAW = "Fenster neu zeichnen";
    static final String MI_RESIZE = "urspr\u00fcngliche Gr\u00f6\u00dfe";
    static final String MI_QUIT = "Programm verlassen";
    Rechner rechner;
    Component grafik;

    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 102) {
            this.rechner.getTastatur().requestFocus();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.exitAction();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getActionCommand();
            if (string.equals(MI_REDRAW)) {
                this.repaint();
            } else if (string.equals(MI_RESIZE)) {
                this.startSize();
            } else if (string.equals(MI_QUIT)) {
                this.exitAction();
            }
        } else if (actionEvent.getSource() == this.rechner.getTastatur()) {
            this.grafik.repaint();
        }
    }

    MenuBar makeMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Programm");
        menuBar.add(menu);
        menu.add(Hawt.makeMenuItem(MI_REDRAW, this, 102));
        menu.add(Hawt.makeMenuItem(MI_RESIZE, this, 117));
        menu.addSeparator();
        menu.add(Hawt.makeMenuItem(MI_QUIT, this, 113));
        return menuBar;
    }

    void startSize() {
        Hawt.setWindowSize(this, 0.8, 0.8);
        Hawt.centerWindow(this);
    }

    void exitAction() {
        this.dispose();
    }

    public Tastatur() {
        super("MRP - Tastatur");
        mainWindow = this;
        this.rechner = new Rechner();
        this.rechner.createTastatur();
        this.grafik = new TastaturDraw(this.rechner.getTastatur());
        this.rechner.getTastatur().addActionListener(this);
        Hgrid.newLayout(this);
        Hgrid.newItem(3.0, 1.0);
        Hgrid.add(0, 0, this.grafik);
        Hgrid.newItem(1.0, 1.0);
        Hgrid.add(1, 0, this.rechner.getTastatur(), 12);
        Hgrid.newItem();
        this.setMenuBar(this.makeMenuBar());
        this.enableEvents(65L);
        this.startSize();
    }

    static {
        MSGJVM = "JavaVM: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";
    }
}

