/*
 * Decompiled with CFR 0.152.
 */
package feu.tastatur;

import feu.tastatur.Tastatur;
import hydro.Num;
import hydro.awt.Hdraw;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;

public class TastaturDraw
extends Container
implements AdjustmentListener {
    private static String[] texte = new String[]{"Adre\u00dfbus", "A0-A3", "3-auf-8-Demultiplexer", "D0", "F010", "Treiber", "F4", "C", "D0-D3", "Datenbus", "Auswahl Tastatur", "Programmversion: v0.08", "A0..A15: F01", "D0..D7: ", Tastatur.MSGJVM};
    private int maxA;
    private int maxW;
    private int maxB;
    private int pfeil1W;
    private int pfeil1H;
    private int rect1W;
    private int text12;
    private int dicke;
    private int[] textW = new int[texte.length];
    private int[] tastW = new int[30];
    private feu.mrp.Tastatur tastatur;
    private int adr;
    private Scrollbar scrollbar;

    public void setFont(Font font) {
        super.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.maxA = fontMetrics.getMaxAscent();
        this.maxW = fontMetrics.charWidth('5');
        this.maxB = 0;
        int n = 0;
        while (n < texte.length) {
            this.textW[n] = fontMetrics.stringWidth(texte[n]);
            ++n;
        }
        n = 0;
        while (n < 30) {
            this.tastW[n] = fontMetrics.stringWidth(feu.mrp.Tastatur.titel[n]);
            if (this.tastW[n] > this.maxB && feu.mrp.Tastatur.titel[n].length() == 1) {
                this.maxB = this.tastW[n];
            }
            ++n;
        }
        this.pfeil1W = 2 * this.textW[0] + 4 * this.maxA;
        this.pfeil1H = 3 * this.maxA;
        this.rect1W = this.textW[2] * 3 / 2;
        this.text12 = this.pfeil1W / 2 - this.textW[12] / 2 + 10;
        this.dicke = fontMetrics.getMaxAscent() / 6;
        this.scrollbar.setLocation(this.text12 - 5, 10 + 4 * this.maxA);
        this.scrollbar.setSize(this.textW[12] + 10 + this.maxW, this.maxA);
        Hdraw.setDicke(this.dicke);
    }

    private final void calcFont() {
        this.setFont(new Font("SansSerif", 1, this.getSize().width / 35));
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101) {
            this.calcFont();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.adr = adjustmentEvent.getValue();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.pfeil1W + this.rect1W + 20, 15 + 2 * this.pfeil1H + 14 * this.maxA);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        this.pfeil1W = 3 * this.textW[0] + 4 * this.maxA;
        this.pfeil1H = 3 * this.maxA;
        int n3 = (this.rect1W - 20) / 8;
        int n4 = this.pfeil1W - this.textW[3] - 10 - this.textW[5];
        int n5 = 2 * this.pfeil1H + 5 * this.maxA;
        int n6 = n4 - 10 - 4 * this.maxA;
        Color[] colorArray = new Color[]{Color.black, Color.black, Color.black, Color.black};
        graphics.setColor(Color.black);
        graphics.setFont(this.getFont());
        graphics.drawString(texte[0], 10 + 3 * this.textW[0] / 2 - this.textW[0] / 2, this.maxA);
        Hdraw.drawPfeilWE(graphics, 10, this.maxA + 5, 3 * this.textW[0], 2 * this.maxA);
        graphics.drawString(texte[1], 10 + 3 * this.textW[0] / 2 - this.textW[1] / 2, 3 * this.maxA);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.text12 - 5, 7 + 3 * this.maxA, this.textW[12] + 10 + this.maxW, 6 + this.maxA);
        graphics.setColor(Color.red);
        graphics.drawString(texte[12] + this.adr, this.text12, 8 + 4 * this.maxA);
        graphics.setColor(Color.black);
        graphics.drawRect(10 + this.pfeil1W, 5, this.rect1W, 2 * this.pfeil1H);
        graphics.drawString(texte[2], 10 + this.pfeil1W + (this.rect1W - this.textW[2]) / 2, 3 * this.maxA);
        graphics.setColor(Color.red);
        Hdraw.drawLine(graphics, 10, 6 * this.maxA, 10 + this.pfeil1W, 6 * this.maxA);
        Hdraw.drawLine(graphics, n4 + this.textW[5] / 2 + 5, 6 * this.maxA, n4 + this.textW[5] / 2 + 5, n5);
        graphics.fillOval(n4 + this.textW[5] / 2 + 5 - this.dicke, 6 * this.maxA - this.dicke, 3 * this.dicke, 3 * this.dicke);
        graphics.setColor(Color.black);
        graphics.drawString(texte[10], 15, 5 + 7 * this.maxA);
        int n7 = 0;
        while (n7 < 8) {
            graphics.drawString(String.valueOf(7 - n7), this.pfeil1W + this.rect1W - n7 * n3 - this.maxW - 5, 2 * this.pfeil1H + 2 * this.maxA);
            graphics.setColor(this.adr == 7 - n7 ? Color.red : Color.black);
            Hdraw.drawLine(graphics, this.pfeil1W + this.rect1W - n7 * n3, 5 + 2 * this.pfeil1H, this.pfeil1W + this.rect1W - n7 * n3, 5 + 2 * this.pfeil1H + 2 * this.maxA);
            if (n7 > 0) {
                n2 = this.tastatur.getSpalte(7 - n7);
                n = 0;
                while (n < 4) {
                    int n8 = feu.mrp.Tastatur.matrix[7 - n7][3 - n];
                    int n9 = Math.max(this.maxB, this.tastW[n8]);
                    String string = feu.mrp.Tastatur.titel[n8];
                    if (this.adr == 7 - n7 && (n2 & 8 >> n) > 0) {
                        colorArray[n] = Color.red;
                    }
                    graphics.setColor((n2 & 8 >> n) == 0 ? Color.white : (this.adr == 7 - n7 ? Color.red : Color.black));
                    graphics.fillOval(this.pfeil1W + this.rect1W - n7 * n3 - this.dicke, 2 * this.pfeil1H + 6 * this.maxA + 2 * n * this.maxA + 5 - this.dicke, 3 * this.dicke, 3 * this.dicke);
                    graphics.setColor((n2 & 8 >> n) == 0 ? Color.gray : Color.red);
                    graphics.fillRect(this.pfeil1W + this.rect1W - n7 * n3 - n9 - 4, 2 * this.pfeil1H + 5 * this.maxA + 2 * n * this.maxA + 1, n9 + 2, this.maxA + 1);
                    graphics.setColor(Color.white);
                    graphics.drawString(string, this.pfeil1W + this.rect1W - n7 * n3 - n9 - 3 + n9 / 2 - this.tastW[n8] / 2, 2 * this.pfeil1H + 6 * this.maxA + 2 * n * this.maxA);
                    ++n;
                }
                graphics.setColor(this.adr == 7 - n7 ? Color.red : Color.black);
                Hdraw.drawLine(graphics, this.pfeil1W + this.rect1W - n7 * n3, 5 + 2 * this.pfeil1H + 2 * this.maxA, this.pfeil1W + this.rect1W - n7 * n3, 5 + 2 * this.pfeil1H + 12 * this.maxA);
                graphics.setColor(Color.black);
                graphics.drawString("F01" + (7 - n7), this.pfeil1W + this.rect1W - n7 * n3 - this.textW[4] / 2, 10 + 2 * this.pfeil1H + 13 * this.maxA + n7 % 2 * this.maxA);
            } else {
                graphics.setColor(Color.black);
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < 4) {
            graphics.setColor(colorArray[n7]);
            Hdraw.drawLine(graphics, this.pfeil1W - this.textW[3], 5 + 2 * this.pfeil1H + 6 * this.maxA + 2 * n7 * this.maxA, this.pfeil1W + this.rect1W - n3 + this.dicke - 1, 5 + 2 * this.pfeil1H + 6 * this.maxA + 2 * n7 * this.maxA);
            graphics.setColor(Color.black);
            graphics.drawString("D" + (3 - n7), this.pfeil1W - this.textW[3] + 5, 2 * this.pfeil1H + 6 * this.maxA + 2 * n7 * this.maxA);
            ++n7;
        }
        graphics.drawRect(this.pfeil1W + this.rect1W, 2 * this.pfeil1H + 6 * this.maxA, this.textW[6] + this.textW[7], 2 * this.maxA);
        graphics.setColor(this.tastatur.getF4() ? Color.red : Color.gray);
        graphics.fillRect(this.pfeil1W + this.rect1W + 3, 2 * this.pfeil1H + 6 * this.maxA + 3, this.textW[6] + this.textW[7] - 5, 2 * this.maxA - 5);
        graphics.setColor(Color.white);
        graphics.drawString(texte[6], this.pfeil1W + this.rect1W + this.maxA - this.textW[6] / 2, 2 * this.pfeil1H + 7 * this.maxA + this.maxA / 2);
        graphics.setColor(Color.black);
        graphics.drawRect(this.pfeil1W + this.rect1W, 2 * this.pfeil1H + 10 * this.maxA, this.textW[6] + this.textW[7], 2 * this.maxA);
        graphics.setColor(this.tastatur.getReset() ? Color.red : Color.gray);
        graphics.fillRect(this.pfeil1W + this.rect1W + 3, 2 * this.pfeil1H + 10 * this.maxA + 3, this.textW[6] + this.textW[7] - 5, 2 * this.maxA - 5);
        graphics.setColor(Color.white);
        graphics.drawString(texte[7], this.pfeil1W + this.rect1W + this.maxA - this.textW[7] / 2, 2 * this.pfeil1H + 11 * this.maxA + this.maxA / 2);
        graphics.setColor(Color.black);
        graphics.drawRect(n4, n5, 10 + this.textW[5], 8 * this.maxA);
        graphics.drawString(texte[5], n4 + 5, n5 + 7 * this.maxA);
        graphics.drawPolygon(new int[]{n4 + 5 + this.textW[5], n4 + 5 + this.textW[5], n4 + 5 + this.maxA}, new int[]{n5 + this.maxA, n5 + 5 * this.maxA, n5 + 3 * this.maxA}, 3);
        graphics.drawOval(n4 + 5, n5 + 3 * this.maxA - this.maxA / 2, this.maxA, this.maxA);
        Hdraw.drawPfeilEW(graphics, n4, n5 + 3 * this.maxA, n6, 2 * this.maxA);
        graphics.drawString(texte[8], n4 - n6 / 2 - this.textW[8] / 2, n5 + 4 * this.maxA + this.maxA / 2);
        graphics.drawString(texte[9], n4 - n6 / 2 - this.textW[9] / 2, n5 + 3 * this.maxA - 5);
        n7 = this.textW[13] + 2 * this.maxW;
        n2 = n4 - n6 / 2 - n7 / 2;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n2 - 5, n5 + 5 * this.maxA + 3, n7 + 10, this.maxA + 6);
        graphics.setColor(Color.red);
        graphics.drawString(texte[13] + Num.getByte(this.tastatur.getSpalte(this.adr)), n2, n5 + 6 * this.maxA + 5);
        graphics.setColor(Color.black);
        n = this.getSize().height - 5;
        graphics.drawString(texte[11], this.getSize().width - 5 - this.textW[11], n - 5 - this.maxA);
        graphics.drawString(texte[14], this.getSize().width - 5 - this.textW[14], n - 5);
        graphics.drawString("= Leitung auf L-Pegel", 40, n - this.maxA - 10);
        graphics.drawString("= Leitung auf H-Pegel", 40, n - 2 * this.maxA - 10);
        graphics.drawLine(10, n - this.maxA - this.maxA / 2 - 10, 36, n - this.maxA - this.maxA / 2 - 10);
        graphics.setColor(Color.red);
        graphics.drawLine(10, n - 2 * this.maxA - this.maxA / 2 - 10, 36, n - 2 * this.maxA - this.maxA / 2 - 10);
        super.paint(graphics);
    }

    public TastaturDraw(feu.mrp.Tastatur tastatur) {
        this.tastatur = tastatur;
        this.setLayout(null);
        this.scrollbar = new Scrollbar(0, 0, 1, 0, 8);
        this.scrollbar.addAdjustmentListener(this);
        this.add(this.scrollbar);
        this.setFont(new Font("SansSerif", 0, 16));
        this.setBackground(Color.white);
        this.enableEvents(17L);
    }
}

