/*
 * Decompiled with CFR 0.152.
 */
package hydro;

import hydro.HSerialize;
import hydro.Num;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class HProperties {
    private String fileName;
    protected Properties p = new Properties();

    public void setFileName(String string) {
        this.fileName = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        if (this.fileName == null) return;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fileName);
            this.p.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        if (this.fileName == null) return;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
            this.p.save(fileOutputStream, "HProperties");
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
        }
    }

    public void list() {
        this.p.list(System.out);
    }

    public void remove(String string) {
        ((Hashtable)this.p).remove(string);
    }

    public void removeAll() {
        this.p = new Properties();
    }

    public void putFile(String string, File file) {
        ((Hashtable)this.p).put(string, file.getAbsolutePath());
    }

    public void putInt(String string, int n) {
        ((Hashtable)this.p).put(string, String.valueOf(n));
    }

    public void putBoolean(String string, boolean bl) {
        ((Hashtable)this.p).put(string, bl ? "1" : "0");
    }

    public boolean getBoolean(String string, boolean bl) {
        return Num.parseBoolean(this.p.getProperty(string), bl);
    }

    public int getInt(String string, int n) {
        return Num.parseInt(this.p.getProperty(string), n);
    }

    public File getFile(String string, File file) {
        return new File(this.p.getProperty(string, file.getAbsolutePath()));
    }

    protected void removeNotUsed(String string, int n) {
        Enumeration enumeration = ((Hashtable)this.p).keys();
        while (enumeration.hasMoreElements()) {
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || (n2 = Num.parseInt(string2.substring(string.length() + 1), -1)) != -1 && n2 < n) continue;
            ((Hashtable)this.p).remove(string2);
        }
    }

    public void putString(String string, String string2) {
        ((Hashtable)this.p).put(string, string2);
    }

    public String getString(String string, String string2) {
        return this.p.getProperty(string, string2);
    }

    public void putPassword(String string, String string2) {
    }

    public void putObject(String string, Object object) {
        ((Hashtable)this.p).put(string, HSerialize.toString(object));
    }

    public Object getObject(String string, Object object) {
        return HSerialize.parseString(this.p.getProperty(string), object);
    }

    public void putBounds(String string, Component component) {
        this.putObject(string, component.getBounds());
    }

    public void getBounds(String string, Component component) {
        component.setBounds((Rectangle)this.getObject(string, component.getBounds()));
    }

    public void putObjects(String string, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            ((Hashtable)this.p).put(string + "." + n, objectArray[n].toString());
            ++n;
        }
        this.removeNotUsed(string, objectArray.length);
    }

    public String[] getStrings(String string) {
        int n = 0;
        String string2 = this.p.getProperty(string + "." + n);
        Vector<String> vector = new Vector<String>();
        while (string2 != null) {
            vector.addElement(string2);
            string2 = this.p.getProperty(string + "." + ++n);
        }
        this.removeNotUsed(string, n);
        String[] stringArray = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public HProperties() {
    }

    public HProperties(String string) {
        this.fileName = string;
    }
}

