/*
 * Decompiled with CFR 0.152.
 */
package hydro;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

public final class Num {
    public static char[] ascii = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String[] DATEFORMAT = new String[]{"EEEE, d.M., kk:mm", "d. MMMM, kk:mm", "d. MMM yyyy, kk:mm", "kk:mm"};

    public static final char ascii(long l) {
        return ascii[new Long(l).intValue() & 0xF];
    }

    public static final char getNibble(int n, int n2) {
        if (n2 > 8) {
            n2 = 8;
        }
        return ascii[n >> n2 * 4 & 0xF];
    }

    public static final char getNibble0(int n) {
        return ascii[n & 0xF];
    }

    public static final char getNibble1(int n) {
        return ascii[n >> 4 & 0xF];
    }

    public static final char getNibble2(int n) {
        return ascii[n >> 8 & 0xF];
    }

    public static final char getNibble3(int n) {
        return ascii[n >> 12 & 0xF];
    }

    public static final String getWord(int n) {
        StringBuffer stringBuffer = new StringBuffer(4);
        Num.appendWord(stringBuffer, n);
        return stringBuffer.toString();
    }

    public static final String getByte(int n) {
        StringBuffer stringBuffer = new StringBuffer(2);
        Num.appendByte(stringBuffer, n);
        return stringBuffer.toString();
    }

    public static final String getBinWord(int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        Num.appendBin(stringBuffer, n, 16);
        return stringBuffer.toString();
    }

    public static final void appendHex(StringBuffer stringBuffer, int n, int n2) {
        while (n2 > 0) {
            stringBuffer.append(Num.getNibble(n, --n2));
        }
    }

    public static final void appendHexLong(StringBuffer stringBuffer, long l, int n) {
        while (n > 0) {
            stringBuffer.append(Num.ascii(l >> --n * 4));
        }
    }

    public static final void appendByte(StringBuffer stringBuffer, int n) {
        stringBuffer.append(Num.getNibble1(n));
        stringBuffer.append(Num.getNibble0(n));
    }

    public static final void appendWord(StringBuffer stringBuffer, int n) {
        stringBuffer.append(Num.getNibble3(n));
        stringBuffer.append(Num.getNibble2(n));
        stringBuffer.append(Num.getNibble1(n));
        stringBuffer.append(Num.getNibble0(n));
    }

    public static final void appendBin(StringBuffer stringBuffer, int n, int n2) {
        while (n2 > 0) {
            stringBuffer.append(ascii[n >> --n2 & 1]);
            if (n2 % 4 != 0) continue;
            stringBuffer.append(' ');
        }
    }

    public static final void appendBinLong(StringBuffer stringBuffer, long l, int n) {
        while (n > 0) {
            stringBuffer.append(Num.ascii(l >> --n & 1L));
            if (n % 4 != 0) continue;
            stringBuffer.append(' ');
        }
    }

    public static final void appendBinNibble(StringBuffer stringBuffer, int n) {
        int n2 = 3;
        while (n2 >= 0) {
            stringBuffer.append(ascii[n >> n2 & 1]);
            --n2;
        }
    }

    public static final void appendBinByte(StringBuffer stringBuffer, int n) {
        Num.appendBinNibble(stringBuffer, n >> 4);
        Num.appendBinNibble(stringBuffer, n);
    }

    public static final void appendBinByte1(StringBuffer stringBuffer, int n) {
        Num.appendBinNibble(stringBuffer, n >> 4);
        stringBuffer.append(' ');
        Num.appendBinNibble(stringBuffer, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final double parseDouble(String string, double d) {
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static final int parseInt(String string) throws NumberFormatException, NullPointerException {
        int n = 10;
        int n2 = 1;
        if (string.charAt(0) == '-') {
            n2 = -1;
            string = string.substring(1);
        }
        if (string.charAt(0) == '%') {
            n = 2;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n3 = 1;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c != '.' && c != ' ') {
                    stringBuffer.append(c);
                }
                ++n3;
            }
            string = stringBuffer.toString();
        } else if (string.charAt(0) == '$' || string.charAt(0) == '#') {
            n = 16;
            string = string.substring(1);
        } else if (string.startsWith("0x")) {
            n = 16;
            string = string.substring(2);
        } else if (string.startsWith("0b")) {
            n = 2;
            string = string.substring(2);
        }
        return Integer.valueOf(string, n) * n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int parseInt(String string, int n) {
        try {
            return Num.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static final boolean parseBoolean(String string) throws NumberFormatException {
        if ((string = string.toLowerCase()).equals("true") || string.equals("yes") || string.equals("on") || string.equals("ja") || string.equals("ein") || string.equals("wahr") || string.equals("1")) {
            return true;
        }
        if (string.equals("false") || string.equals("no") || string.equals("off") || string.equals("nein") || string.equals("aus") || string.equals("falsch") || string.equals("0")) {
            return false;
        }
        throw new NumberFormatException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean parseBoolean(String string, boolean bl) {
        try {
            return Num.parseBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static final int randomInt(Random random, int n, int n2) {
        return n + Math.abs(random.nextInt() % (n2 - n + 1));
    }

    public static final String byteFormat(double d) {
        String string = null;
        if (d < 1024.0) {
            string = "0 'b'";
        } else if (d < 1048576.0) {
            string = d < 10240.0 ? "#.00 'K'" : (d < 102400.0 ? "#.0 'K'" : "# 'K'");
            d /= 1024.0;
        } else if (d < 1.073741824E9) {
            d /= 1048576.0;
            string = "#.00 'MB'";
        } else {
            d /= 1.073741824E9;
            string = "#.00 'GB'";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public static final String longFormat(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#,### 'Byte'");
        return decimalFormat.format(d);
    }

    public static final String relativeDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date);
        int n = 0;
        n = gregorianCalendar2.get(1) == gregorianCalendar.get(1) ? (gregorianCalendar2.get(6) == gregorianCalendar.get(6) ? 3 : (gregorianCalendar2.get(6) + 7 > gregorianCalendar.get(6) ? 0 : 1)) : 2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT[n]);
        return simpleDateFormat.format(date);
    }
}

