/*
 * Decompiled with CFR 0.152.
 */
package hydro.awt;

import hydro.awt.Border;
import hydro.awt.NumInterface;
import java.awt.AWTEventMulticaster;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class BitCheckbox
extends Border
implements NumInterface {
    private String[] names;
    private Checkbox[] boxes;
    private int data;
    private ActionListener numListener;
    private ItemListener itemListener;

    public final int getAnzBytes() {
        if (this.names.length > 24) {
            return 4;
        }
        if (this.names.length > 16) {
            return 3;
        }
        if (this.names.length > 8) {
            return 2;
        }
        return 1;
    }

    public final void setData(int n) {
        this.data = n;
        this.showData();
    }

    public final int getData() {
        return this.data;
    }

    private final void showData() {
        int n = 0;
        while (n < this.names.length) {
            this.boxes[n].setState((this.data >> n & 1) > 0);
            ++n;
        }
    }

    private final void changeData() {
        this.data = 0;
        int n = 0;
        while (n < this.names.length) {
            if (this.boxes[n].getState()) {
                this.data |= 1 << n;
            }
            ++n;
        }
        if (this.numListener != null) {
            this.processNumEvent();
        }
    }

    public final void addNumListener(ActionListener actionListener) {
        this.numListener = AWTEventMulticaster.add(this.numListener, actionListener);
    }

    public final void removeNumListener(ActionListener actionListener) {
        this.numListener = AWTEventMulticaster.remove(this.numListener, actionListener);
    }

    protected final void processNumEvent() {
        this.numListener.actionPerformed(new ActionEvent(this, 0, null));
    }

    /* synthetic */ void access$0() {
        this.changeData();
    }

    public BitCheckbox(String string, String[] stringArray) {
        super(string, new GridLayout(stringArray.length, 1));
        this.names = stringArray;
        BitCheckbox bitCheckbox = this;
        if (bitCheckbox == null) {
            throw null;
        }
        this.itemListener = new ItemListener(bitCheckbox){
            private final /* synthetic */ BitCheckbox this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                this.this$0.access$0();
            }
            {
                this.this$0 = bitCheckbox;
                this.constructor$0(bitCheckbox);
            }

            public void constructor$0(BitCheckbox bitCheckbox) {
            }
        };
        this.boxes = new Checkbox[stringArray.length];
        int n = stringArray.length - 1;
        while (n >= 0) {
            this.boxes[n] = new Checkbox(stringArray[n]);
            this.getPanel().add(this.boxes[n]);
            this.boxes[n].addItemListener(this.itemListener);
            --n;
        }
        this.showData();
    }
}

