/*
 * Decompiled with CFR 0.152.
 */
package hydro.awt;

import hydro.Num;
import hydro.awt.Hawt;
import hydro.awt.Hgrid;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;

public class HDialog
extends Dialog {
    public static final int OKBUTTON = 1;
    public static final int YESBUTTON = 2;
    public static final int NOBUTTON = 4;
    public static final int IGNOREBUTTON = 8;
    public static final int RETRYBUTTON = 16;
    public static final int CANCELBUTTON = 32;
    public static final int OK = 0;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int IGNORE = 3;
    public static final int RETRY = 4;
    public static final int CANCEL = 5;
    public static final int BUTTONZAHL = 6;
    public static final int OKTITLE = 0;
    public static final int ERRORTITLE = 4096;
    public static final int ASKTITLE = 8192;
    public static final int INPUTTITLE = 12288;
    public static final int INPUTLINE = 256;
    public static final int OKBOX = 1;
    public static final int OKCANCELBOX = 8225;
    public static final int INPUTBOX = 12577;
    public static final int ERRORBOX = 4097;
    public static final int YESNOBOX = 8198;
    public static final int YESNOCANCELBOX = 8230;
    public static final int RETRYBOX = 4152;
    private static final String[] buttonTitle = new String[]{"Ok", "Ja", "Nein", "Ignorieren", "Wiederholen", "Abbruch"};
    private static final char[] buttonKey = new char[]{'o', 'j', 'n', 'i', 'w', 'a'};
    private static final String[] titles = new String[]{"Hinweis", "Fehler", "Frage", "Eingabe"};
    private int ergebnis = 5;
    private int defaultErgebnis = -1;
    private int textLines;
    private HAction actionHandler;
    private HKey keyHandler;
    private Component[] buttons = new Component[6];
    private TextField textField;

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        switch (windowEvent.getID()) {
            case 201: {
                this.dispose(5);
            }
        }
    }

    private final void layoutText(String string) {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        if (n > 0) {
            stringArray = new String[n + 1];
            n2 = 0;
            n = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                if (string.charAt(n3) == '\n') {
                    stringArray[n++] = string.substring(n2, n3);
                    n2 = n3 + 1;
                }
                ++n3;
            }
            stringArray[n] = string.substring(n2);
        } else {
            stringArray = new String[]{string};
        }
        this.layoutText(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void layoutText(Object object) {
        Hgrid.newItem(1.0, 1.0, 1, 15);
        Hgrid.setInsets(3, 5, -2, 5);
        try {
            int n = Array.getLength(object);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return;
                }
                int n3 = 0;
                String string = Array.get(object, n2).toString();
                if (string.length() > 0) {
                    if (string.charAt(0) == '\t') {
                        n3 = 1;
                        string = string.substring(1);
                    } else if (string.charAt(0) == '\r') {
                        n3 = 2;
                        string = string.substring(1);
                    }
                }
                Hgrid.add(1, ++this.textLines, new Label(string, n3));
                Hgrid.setGrow(1.0, 0.0, 2);
                Hgrid.setInsets(-2, 5, -2, 5);
                ++n2;
            }
        }
        catch (Exception exception) {
        }
    }

    public final int getErgebnis() {
        return this.ergebnis;
    }

    public void dispose(int n) {
        this.ergebnis = n;
        this.dispose();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 150) {
            dimension.width = 150;
        }
        if (dimension.height < 100) {
            dimension.height = 100;
        }
        return dimension;
    }

    public static int runDialog(Frame frame, int n, Object object) {
        HDialog hDialog = new HDialog(frame, n, object);
        hDialog.show();
        return hDialog.getErgebnis();
    }

    public static void ok(Frame frame, Object object) {
        HDialog.runDialog(frame, 1, object);
    }

    public static void ok(Object object) {
        HDialog.runDialog(null, 1, object);
    }

    public static void error(Frame frame, Object object) {
        HDialog.runDialog(frame, 4097, object);
    }

    public static boolean yesNo(Frame frame, Object object) {
        return HDialog.runDialog(frame, 8198, object) == 1;
    }

    public static String inputBox(Frame frame, int n, Object object, String string) {
        HDialog hDialog = new HDialog(frame, n, object);
        ((TextComponent)hDialog.textField).setText(string);
        hDialog.show();
        if (hDialog.getErgebnis() != 0) {
            return null;
        }
        return hDialog.textField.getText();
    }

    public static String inputBox(Frame frame, Object object) {
        return HDialog.inputBox(frame, 12577, object, "");
    }

    public static int inputBox(Frame frame, Object object, int n, int n2) {
        return Num.parseInt(HDialog.inputBox(frame, 12577, object, String.valueOf(n2)), n);
    }

    /* synthetic */ int access$1() {
        return this.defaultErgebnis;
    }

    /* synthetic */ void access$2(int n) {
        this.defaultErgebnis = n;
    }

    /* synthetic */ HAction access$3() {
        return this.actionHandler;
    }

    /* synthetic */ HKey access$4() {
        return this.keyHandler;
    }

    /* synthetic */ Component[] access$5() {
        return this.buttons;
    }

    public HDialog(Frame frame, int n, Object object) {
        super(frame == null ? new Frame() : frame, true);
        HDialog hDialog = this;
        if (hDialog == null) {
            throw null;
        }
        this.actionHandler = hDialog.new HAction();
        HDialog hDialog2 = this;
        if (hDialog2 == null) {
            throw null;
        }
        this.keyHandler = hDialog2.new HKey();
        this.enableEvents(64L);
        this.setTitle(titles[(n >> 12) % 3]);
        this.setResizable(false);
        Hgrid.newLayout(this);
        if (object instanceof String) {
            this.layoutText((String)object);
        } else {
            this.layoutText(object);
        }
        Hgrid.setInsets(3, 3, 3, 3);
        if ((n & 0x100) > 0) {
            this.textField = new TextField(20);
            this.textField.addKeyListener(this.keyHandler);
            Hgrid.newItem(1.0, 0.0, 2);
            Hgrid.add(1, ++this.textLines, this.textField, 17);
        }
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 6, 5, 5));
        int n2 = 0;
        while (n2 < 6) {
            if ((n & 1 << n2) > 0) {
                HDialog hDialog3 = this;
                if (hDialog3 == null) {
                    throw null;
                }
                this.buttons[n2] = hDialog3.new HButton(n2);
                panel.add(this.buttons[n2]);
            }
            ++n2;
        }
        Hgrid.newItem();
        Hgrid.add(1, ++this.textLines, panel, 10);
        this.pack();
        if (frame == null) {
            Hawt.centerWindow(this);
        } else {
            Point point = frame.getLocationOnScreen();
            point.translate(30, 30);
            ((Component)this).setLocation(point);
        }
    }

    public class HButton
    extends Button {
        int id;

        public String toString() {
            String string = super.toString();
            return string.substring(0, string.length() - 1) + ",id=" + this.id + "]";
        }

        public HButton(int n) {
            super(buttonTitle[n]);
            this.id = n;
            if (HDialog.this.access$1() == -1) {
                HDialog.this.access$2(n);
            }
            this.addActionListener(HDialog.this.access$3());
            this.addKeyListener(HDialog.this.access$4());
        }
    }

    public class HAction
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            HDialog.this.dispose(((HButton)actionEvent.getSource()).id);
        }
    }

    public class HKey
    extends KeyAdapter {
        public final void keyReleased(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\n' || c == '\r') {
                HDialog.this.dispose(HDialog.this.access$1());
                return;
            }
            if (c == '\u001b') {
                HDialog.this.dispose(5);
                return;
            }
            int n = 0;
            while (n < 6) {
                if (HDialog.this.access$5()[n] != null) {
                    HButton hButton = (HButton)HDialog.this.access$5()[n];
                    int n2 = keyEvent.getModifiers();
                    if (c == buttonKey[hButton.id] && (n2 == 0 || n2 == 8)) {
                        HDialog.this.dispose(hButton.id);
                        return;
                    }
                }
                ++n;
            }
        }
    }
}

