/*
 * Decompiled with CFR 0.152.
 */
package hydro.awt;

import hydro.Num;
import hydro.awt.NumInterface;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.TextEvent;

public class NumTextField
extends TextField
implements NumInterface {
    public static final int HEX = 0;
    public static final int BIN = 1;
    public static final int DEZ = 2;
    private static final Color VALID = Color.black;
    private static final Color INVALID = Color.red;
    private int anzeigeArt;
    private int anzBytes;
    private int data;
    private boolean showPrefix;
    private boolean validData;
    private ActionListener numListener;

    public final void setAnzeigeFormat(int n) {
        this.anzeigeArt = n % 3;
        switch (n) {
            case 0: {
                this.setColumns(this.anzBytes * 2 + 1);
                break;
            }
            case 1: {
                this.setColumns(this.anzBytes * 10 + 1);
                break;
            }
            case 2: {
                this.setColumns(this.anzBytes * 3 + 1);
                break;
            }
        }
        this.showData();
    }

    public final boolean getShowPrefix() {
        return this.showPrefix;
    }

    public final void setShowPrefix(boolean bl) {
        this.showPrefix = bl;
        this.showData();
    }

    public final int getAnzBytes() {
        return this.anzBytes;
    }

    public final boolean isValidData() {
        return this.validData;
    }

    private final void setValidData(boolean bl) {
        this.validData = bl;
        this.setForeground(bl ? VALID : INVALID);
    }

    public final int getData() {
        return this.data;
    }

    public final void setData(int n) {
        this.data = n;
        this.showData();
    }

    public final void addNumListener(ActionListener actionListener) {
        this.numListener = AWTEventMulticaster.add(this.numListener, actionListener);
    }

    public final void removeNumListener(ActionListener actionListener) {
        this.numListener = AWTEventMulticaster.remove(this.numListener, actionListener);
    }

    protected final void processNumEvent() {
        this.numListener.actionPerformed(new ActionEvent(this, 0, null));
    }

    private final void showData() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.anzeigeArt) {
            case 0: {
                if (this.showPrefix) {
                    stringBuffer.append('$');
                }
                Num.appendHex(stringBuffer, this.data, this.anzBytes * 2);
                break;
            }
            case 1: {
                if (this.showPrefix) {
                    stringBuffer.append('%');
                }
                Num.appendBin(stringBuffer, this.data, this.anzBytes * 8);
                break;
            }
            case 2: {
                stringBuffer.append(String.valueOf(this.data & -1 >> 8 - this.anzBytes));
                break;
            }
        }
        this.setValidData(true);
        ((TextComponent)this).setText(stringBuffer.toString());
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1005) {
            this.showData();
        }
        super.processFocusEvent(focusEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processTextEvent(TextEvent textEvent) {
        block3: {
            try {
                int n = Num.parseInt(this.getText());
                if (this.data == n) break block3;
                this.data = n;
                this.setValidData(true);
                if (this.numListener != null) {
                    this.processNumEvent();
                }
            }
            catch (Exception exception) {
                this.setValidData(false);
            }
        }
        super.processTextEvent(textEvent);
    }

    public NumTextField(int n) {
        this(n, 0, true);
    }

    public NumTextField(int n, int n2, boolean bl) {
        this.anzeigeArt = n2;
        this.anzBytes = n;
        this.showPrefix = bl;
        this.enableEvents(1028L);
        this.showData();
    }
}

