/*
 * Decompiled with CFR 0.152.
 */
package hydro;

public class DataArray {
    private Object[] data;
    private int free;

    public final Object at(int n) {
        return n < this.free && n >= 0 ? this.data[n] : null;
    }

    public final int size() {
        return this.free;
    }

    public final int capacity() {
        return this.data.length;
    }

    public final void put(int n, Object object) {
        this.data[n] = object;
    }

    public final void add(Object object) {
        if (this.free == this.data.length) {
            this.resize(2 * this.free);
        }
        this.data[this.free++] = object;
    }

    public final int find(Object object) {
        int n = 0;
        while (n < this.free) {
            if (this.data[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final void remove() {
        if (this.free > 0) {
            this.data[this.free--] = null;
        }
    }

    public final void remove(int n) {
        this.data[n] = this.data[this.free];
        this.data[this.free--] = null;
    }

    public final boolean remove(Object object) {
        int n = this.find(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public final void pack() {
        int n = 0;
        while (n < this.free) {
            if (this.data[n] == null) {
                this.remove(n);
                continue;
            }
            ++n;
        }
    }

    public final void resize() {
        this.resize(this.free);
    }

    public final void resize(int n) {
        if (this.free >= n) {
            return;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.data, 0, objectArray, 0, this.free);
        this.data = objectArray;
    }

    public DataArray(int n) {
        this.data = new Object[n];
    }

    public DataArray() {
        this(256);
    }
}

