/*
 * Decompiled with CFR 0.152.
 */
package hydro.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;

public final class Taste
extends Component {
    public static int TASTE_DOWN = 2000;
    public static int TASTE_UP = 2001;
    protected static int CKEYNORMAL = 0;
    protected static int CKEYPRESSED = 1;
    protected static int CKEYACTIVE = 2;
    protected static int CTEXTNORMAL = 3;
    protected static int CTEXTPRESSED = 4;
    protected static int CTEXTACTIVE = 5;
    private String name;
    private String command;
    private int fontFactor;
    private int rectFactor;
    private Font font;
    private boolean pressed;
    private boolean active;
    private boolean permanent;
    private int xp;
    private int yp;
    private int x;
    private int y;
    private int w;
    private int h;
    private ActionListener actionListener = null;
    private Color[] colors = new Color[]{Color.gray, Color.red, Color.gray, Color.white, Color.white, Color.yellow};

    public String getActionCommand() {
        return this.command;
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public String getLabel() {
        return this.name;
    }

    public void setLabel(String string) {
        this.name = string;
        this.repaint();
    }

    public boolean getPressed() {
        return this.pressed;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getPermanent() {
        return this.permanent;
    }

    public void setPressed(boolean bl) {
        this.pressed = bl;
        this.repaint();
    }

    public void setPermanent(boolean bl) {
        this.pressed = this.permanent = bl;
        this.repaint();
    }

    public int getRectFactor() {
        return this.rectFactor;
    }

    public void setRectFactor(int n) {
        this.rectFactor = Math.abs(n % 10);
        this.font = null;
        this.repaint();
    }

    public int getFontFactor() {
        return this.fontFactor;
    }

    public void setFontFactor(int n) {
        this.fontFactor = Math.abs(n % 100);
        this.font = null;
        this.repaint();
    }

    public void setColor(int n, Color color) {
        this.colors[n] = color;
        this.repaint();
    }

    public Color getColor(int n) {
        return this.colors[n];
    }

    public Dimension getPreferredSize() {
        return new Dimension(40, 40);
    }

    public Dimension getMinimumSize() {
        return new Dimension(15, 15);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private void calcFont(Graphics graphics) {
        this.font = new Font("SansSerif", 1, Math.min(this.getSize().width, this.getSize().height) * this.fontFactor / 100);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        this.xp = (this.w - fontMetrics.stringWidth(this.name)) / 2;
        this.yp = (this.h + fontMetrics.getAscent()) / 2;
        this.x = this.w / this.rectFactor;
        this.y = this.h / this.rectFactor;
        this.w -= 2 * this.x;
        this.h -= 2 * this.y;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.font == null) {
            this.calcFont(graphics);
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setFont(this.font);
        if (this.pressed) {
            n2 = CKEYPRESSED;
            n = CTEXTPRESSED;
        } else if (this.active) {
            n2 = CKEYACTIVE;
            n = CTEXTACTIVE;
        } else {
            n2 = CKEYNORMAL;
            n = CTEXTNORMAL;
        }
        graphics.setColor(this.getColor(n2));
        graphics.fill3DRect(this.x, this.y, this.w, this.h, !this.pressed);
        graphics.setColor(this.getColor(n));
        graphics.drawString(this.name, this.xp, this.yp);
    }

    public void processAction() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, this.pressed ? TASTE_DOWN : TASTE_UP, this.command));
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101) {
            this.font = null;
        }
        super.processComponentEvent(componentEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 504) {
            this.active = true;
            this.repaint();
        } else if (mouseEvent.getID() == 505) {
            this.active = false;
            if (!this.permanent) {
                this.pressed = false;
            }
            this.repaint();
        } else if (mouseEvent.getID() == 501) {
            this.pressed = true;
            if (mouseEvent.getModifiers() == 16 && !this.permanent) {
                this.processAction();
            }
            this.repaint();
        } else if (mouseEvent.getID() == 502) {
            this.pressed = mouseEvent.getModifiers() != 16 ? (this.permanent = !this.permanent) : false;
            this.processAction();
            this.repaint();
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public Taste(String string) {
        this.name = string;
        this.command = string;
        this.fontFactor = 60;
        this.rectFactor = 7;
        this.font = null;
        this.enableEvents(17L);
    }
}

