/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp;

import feu.mrp.TaktZaehler;
import feu.mrp.awt.Rechner;
import feu.mrp.memory.Speicher;
import hydro.Num;
import hydro.awt.Taste;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public final class Emulator
implements ActionListener {
    static final int REGD = 0;
    static final int REGX = 1;
    static final int REGY = 2;
    static final int REGU = 3;
    static final int REGS = 4;
    static final int REGPC = 5;
    static final int REGCC = 6;
    static final int REGDP = 7;
    static final int REGA = 8;
    static final int REGB = 9;
    static final int FLAG_E = 128;
    static final int FLAG_F = 64;
    static final int FLAG_H = 32;
    static final int FLAG_I = 16;
    static final int FLAG_N = 8;
    static final int FLAG_Z = 4;
    static final int FLAG_V = 2;
    static final int FLAG_C = 1;
    static final int FLAG_COMPUTE = 15;
    static final int CMASK8 = 256;
    static final int CMASK16 = 65536;
    static final int SHIFTDIRLEFT = 0;
    static final int SHIFTDIRRIGHT = 1;
    static final int SHIFTARIT = 0;
    static final int SHIFTLOG = 1;
    static final int SHIFTROT = 2;
    static final int OPAND = 0;
    static final int OPEOR = 1;
    static final int OPOR = 2;
    Rechner rechner;
    Speicher mem;
    TaktZaehler takt;
    int[] reg = new int[8];
    boolean breakPressed = false;

    public void init() {
        this.reg[0] = this.mem.get2x8h(245);
        this.reg[1] = this.mem.get2x8h(248);
        this.reg[2] = this.mem.get2x8h(250);
        this.reg[4] = this.mem.get2x8h(242);
        this.reg[3] = this.mem.get2x8h(252);
        this.reg[5] = this.mem.get2x8h(254);
        this.reg[6] = this.mem.getMem(244);
        this.reg[7] = this.mem.getMem(247);
        this.rechner.getTastatur().addActionListener(this);
    }

    public void exit() {
        this.rechner.getTastatur().removeActionListener(this);
        this.mem.set2x8h(245, this.reg[0]);
        this.mem.set2x8h(248, this.reg[1]);
        this.mem.set2x8h(250, this.reg[2]);
        this.mem.set2x8h(242, this.reg[4]);
        this.mem.set2x8h(252, this.reg[3]);
        this.mem.set2x8h(254, this.reg[5]);
        this.mem.setMem(244, this.reg[6]);
        this.mem.setMem(247, this.reg[7]);
    }

    public void debugWrite() {
        System.out.println("Emulator-Trace:");
        System.out.println("A: " + Num.getByte(this.get(8)) + "; B: " + Num.getByte(this.get(9)) + "; D: " + Num.getWord(this.get(0)) + "; X: " + Num.getWord(this.get(1)) + "; Y: " + Num.getWord(this.get(2)) + "; S: " + Num.getWord(this.get(4)) + "; U: " + Num.getWord(this.get(3)) + "; PC: " + Num.getWord(this.get(5)) + "; CC: " + Num.getByte(this.get(6)) + "; DP: " + Num.getByte(this.get(7)));
        System.out.println("PC:");
        this.mem.debugLine(this.get(5) - 32, 5);
        System.out.println("Stack:");
        this.mem.debugLine(this.get(4) - 32, 5);
    }

    public void run() {
        while (!this.step() && !this.breakPressed) {
        }
    }

    public boolean step() {
        int n = this.getOpcode();
        switch (n) {
            case 0: {
                this.negmem(this.getDirectAdr());
                this.takt.inc(2);
                break;
            }
            case 3: {
                this.commem(this.getDirectAdr());
                this.takt.inc(2);
                break;
            }
            case 4: {
                this.shiftmem(this.getDirectAdr(), 1, 1);
                this.takt.inc(2);
                break;
            }
            case 6: {
                this.shiftmem(this.getDirectAdr(), 1, 2);
                this.takt.inc(2);
                break;
            }
            case 7: {
                this.shiftmem(this.getDirectAdr(), 1, 0);
                this.takt.inc(2);
                break;
            }
            case 8: {
                this.shiftmem(this.getDirectAdr(), 0, 0);
                this.takt.inc(2);
                break;
            }
            case 9: {
                this.shiftmem(this.getDirectAdr(), 0, 2);
                this.takt.inc(2);
                break;
            }
            case 10: {
                this.incmem(this.getDirectAdr(), -1);
                this.takt.inc(2);
                break;
            }
            case 12: {
                this.incmem(this.getDirectAdr(), 1);
                this.takt.inc(2);
                break;
            }
            case 13: {
                this.tst(this.getDirect8());
                this.takt.inc(3);
                break;
            }
            case 14: {
                this.j(this.getDirectAdr(), false);
                this.takt.inc();
                break;
            }
            case 15: {
                this.setDirect8(0);
                this.clrFlags();
                this.takt.inc(3);
                break;
            }
            case 16: {
                if (!this.opcode10()) break;
                return true;
            }
            case 17: {
                if (!this.opcode11()) break;
                return true;
            }
            case 18: {
                break;
            }
            case 19: {
                this.reg[5] = this.reg[5] - 1;
                break;
            }
            case 22: {
                this.pcrel16(true);
                this.takt.inc(2);
                break;
            }
            case 23: {
                this.pcrelSR(true);
                this.takt.inc(4);
                break;
            }
            case 25: {
                this.daa();
                this.takt.inc();
                break;
            }
            case 26: {
                this.set(6, this.get(6) | this.getOpcode());
                this.takt.inc();
                break;
            }
            case 28: {
                this.set(6, this.get(6) & this.getOpcode());
                this.takt.inc();
                break;
            }
            case 29: {
                this.sex();
                this.takt.inc();
                break;
            }
            case 30: {
                this.tfr(true);
                this.takt.inc(6);
                break;
            }
            case 31: {
                this.tfr(false);
                this.takt.inc(4);
                break;
            }
            case 32: {
                this.pcrel8(true);
                this.takt.inc();
                break;
            }
            case 33: {
                this.pcrel8(false);
                this.takt.inc();
                break;
            }
            case 34: {
                this.pcrel8(!(this.getCC(1) || this.getCC(4)));
                this.takt.inc();
                break;
            }
            case 35: {
                this.pcrel8(this.getCC(1) || this.getCC(4));
                this.takt.inc();
                break;
            }
            case 36: {
                this.pcrel8(!this.getCC(1));
                this.takt.inc();
                break;
            }
            case 37: {
                this.pcrel8(this.getCC(1));
                this.takt.inc();
                break;
            }
            case 38: {
                this.pcrel8(!this.getCC(4));
                this.takt.inc();
                break;
            }
            case 39: {
                this.pcrel8(this.getCC(4));
                this.takt.inc();
                break;
            }
            case 40: {
                this.pcrel8(!this.getCC(2));
                this.takt.inc();
                break;
            }
            case 41: {
                this.pcrel8(this.getCC(2));
                this.takt.inc();
                break;
            }
            case 42: {
                this.pcrel8(!this.getCC(8));
                this.takt.inc();
                break;
            }
            case 43: {
                this.pcrel8(this.getCC(8));
                this.takt.inc();
                break;
            }
            case 44: {
                this.pcrel8(this.getCC(8) == this.getCC(2));
                this.takt.inc();
                break;
            }
            case 45: {
                this.pcrel8(this.getCC(8) != this.getCC(2));
                this.takt.inc();
                break;
            }
            case 46: {
                this.pcrel8(!(this.getCC(4) || this.getCC(8) != this.getCC(2)));
                this.takt.inc();
                break;
            }
            case 47: {
                this.pcrel8(this.getCC(4) || this.getCC(8) != this.getCC(2));
                this.takt.inc();
                break;
            }
            case 48: {
                this.reg[1] = this.getIndexedAdr();
                this.setCC(4, this.reg[1] == 0);
                this.takt.inc(2);
                break;
            }
            case 49: {
                this.reg[2] = this.getIndexedAdr();
                this.setCC(4, this.reg[2] == 0);
                this.takt.inc(2);
                break;
            }
            case 50: {
                this.reg[4] = this.getIndexedAdr();
                this.takt.inc(2);
                break;
            }
            case 51: {
                this.reg[3] = this.getIndexedAdr();
                this.takt.inc(2);
                break;
            }
            case 52: {
                this.psh(4, this.getOpcode());
                this.takt.inc(3);
                break;
            }
            case 53: {
                this.pul(4, this.getOpcode());
                this.takt.inc(3);
                break;
            }
            case 54: {
                this.psh(3, this.getOpcode());
                this.takt.inc(3);
                break;
            }
            case 55: {
                this.pul(3, this.getOpcode());
                this.takt.inc(3);
                break;
            }
            case 57: {
                this.rt(false);
                this.takt.inc(2);
                break;
            }
            case 58: {
                this.reg[1] = this.reg[1] + this.get(9);
                this.takt.inc(2);
                break;
            }
            case 59: {
                this.rt(true);
                this.takt.inc(2);
                break;
            }
            case 60: {
                this.reg[6] = this.reg[6] & this.getOpcode();
                this.takt.inc(18);
                return true;
            }
            case 61: {
                this.mul();
                this.takt.inc(10);
                break;
            }
            case 63: {
                return true;
            }
            case 64: {
                this.neg(8);
                this.takt.inc();
                break;
            }
            case 67: {
                this.set(8, this.com(this.get(8)));
                this.takt.inc();
                break;
            }
            case 68: {
                this.set(8, this.shift(this.get(8), 1, 1));
                this.takt.inc();
                break;
            }
            case 70: {
                this.set(8, this.shift(this.get(8), 1, 2));
                this.takt.inc();
                break;
            }
            case 71: {
                this.set(8, this.shift(this.get(8), 1, 0));
                this.takt.inc();
                break;
            }
            case 72: {
                this.set(8, this.shift(this.get(8), 0, 0));
                this.takt.inc();
                break;
            }
            case 73: {
                this.set(8, this.shift(this.get(8), 0, 2));
                this.takt.inc();
                break;
            }
            case 74: {
                this.set(8, this.inc(this.get(8), -1));
                this.takt.inc();
                break;
            }
            case 76: {
                this.set(8, this.inc(this.get(8), 1));
                this.takt.inc();
                break;
            }
            case 77: {
                this.tst(this.get(8));
                this.takt.inc();
                break;
            }
            case 79: {
                this.set(8, 0);
                this.clrFlags();
                this.takt.inc();
                break;
            }
            case 80: {
                this.neg(9);
                this.takt.inc();
                break;
            }
            case 83: {
                this.set(9, this.com(this.get(9)));
                this.takt.inc();
                break;
            }
            case 84: {
                this.set(9, this.shift(this.get(9), 1, 1));
                this.takt.inc();
                break;
            }
            case 86: {
                this.set(9, this.shift(this.get(9), 1, 2));
                this.takt.inc();
                break;
            }
            case 87: {
                this.set(9, this.shift(this.get(9), 1, 0));
                this.takt.inc();
                break;
            }
            case 88: {
                this.set(9, this.shift(this.get(9), 0, 0));
                this.takt.inc();
                break;
            }
            case 89: {
                this.set(9, this.shift(this.get(9), 0, 2));
                this.takt.inc();
                break;
            }
            case 90: {
                this.set(9, this.inc(this.get(9), -1));
                this.takt.inc();
                break;
            }
            case 92: {
                this.set(9, this.inc(this.get(9), 1));
                this.takt.inc();
                break;
            }
            case 93: {
                this.tst(this.get(9));
                this.takt.inc();
                break;
            }
            case 95: {
                this.set(9, 0);
                this.clrFlags();
                this.takt.inc();
                break;
            }
            case 96: {
                this.negmem(this.getIndexedAdr());
                this.takt.inc(2);
                break;
            }
            case 99: {
                this.commem(this.getIndexedAdr());
                this.takt.inc(2);
                break;
            }
            case 100: {
                this.shiftmem(this.getIndexedAdr(), 1, 1);
                this.takt.inc(2);
                break;
            }
            case 102: {
                this.shiftmem(this.getIndexedAdr(), 1, 2);
                this.takt.inc(2);
                break;
            }
            case 103: {
                this.shiftmem(this.getIndexedAdr(), 1, 0);
                this.takt.inc(2);
                break;
            }
            case 104: {
                this.shiftmem(this.getIndexedAdr(), 0, 0);
                this.takt.inc(2);
                break;
            }
            case 105: {
                this.shiftmem(this.getIndexedAdr(), 0, 2);
                this.takt.inc(2);
                break;
            }
            case 106: {
                this.incmem(this.getIndexedAdr(), -1);
                this.takt.inc(2);
                break;
            }
            case 108: {
                this.incmem(this.getIndexedAdr(), 1);
                this.takt.inc(2);
                break;
            }
            case 109: {
                this.tst(this.getIndexed8());
                this.takt.inc(3);
                break;
            }
            case 110: {
                this.j(this.getIndexedAdr(), false);
                this.takt.inc();
                break;
            }
            case 111: {
                this.setIndexed8(0);
                this.clrFlags();
                this.takt.inc(3);
                break;
            }
            case 112: {
                this.negmem(this.getExtendedAdr());
                this.takt.inc(2);
                break;
            }
            case 115: {
                this.commem(this.getExtendedAdr());
                this.takt.inc(2);
                break;
            }
            case 116: {
                this.shiftmem(this.getExtendedAdr(), 1, 1);
                this.takt.inc(2);
                break;
            }
            case 118: {
                this.shiftmem(this.getExtendedAdr(), 1, 2);
                this.takt.inc(2);
                break;
            }
            case 119: {
                this.shiftmem(this.getExtendedAdr(), 1, 0);
                this.takt.inc(2);
                break;
            }
            case 120: {
                this.shiftmem(this.getExtendedAdr(), 0, 0);
                this.takt.inc(2);
                break;
            }
            case 121: {
                this.shiftmem(this.getExtendedAdr(), 0, 2);
                this.takt.inc(2);
                break;
            }
            case 122: {
                this.incmem(this.getExtendedAdr(), -1);
                this.takt.inc(2);
                break;
            }
            case 124: {
                this.incmem(this.getExtendedAdr(), 1);
                this.takt.inc(2);
                break;
            }
            case 125: {
                this.tst(this.getExtended8());
                this.takt.inc(3);
                break;
            }
            case 126: {
                this.j(this.getOpcode16(), false);
                this.takt.inc();
                break;
            }
            case 127: {
                this.setExtended8(0);
                this.clrFlags();
                this.takt.inc(3);
                break;
            }
            case 128: {
                this.set(8, this.add8(this.get(8), -this.getOpcode(), 0));
                break;
            }
            case 129: {
                this.cmp8(8, this.getOpcode());
                break;
            }
            case 130: {
                this.set(8, this.add8(this.get(8), -this.getOpcode(), -1));
                break;
            }
            case 131: {
                this.addd(-this.getOpcode16());
                this.takt.inc();
                break;
            }
            case 132: {
                this.bitop(8, this.getOpcode(), 0);
                break;
            }
            case 133: {
                this.bit(8, this.getOpcode());
                break;
            }
            case 134: {
                this.ld(8, this.getOpcode(), 256);
                break;
            }
            case 136: {
                this.bitop(8, this.getOpcode(), 1);
                break;
            }
            case 137: {
                this.set(8, this.add8(this.get(8), this.getOpcode(), 1));
                break;
            }
            case 138: {
                this.bitop(8, this.getOpcode(), 2);
                break;
            }
            case 139: {
                this.set(8, this.add8(this.get(8), this.getOpcode(), 0));
                break;
            }
            case 140: {
                this.cmp16(1, this.getOpcode16());
                this.takt.inc();
                break;
            }
            case 141: {
                this.pcrelSR(false);
                this.takt.inc(3);
                break;
            }
            case 142: {
                this.ld(1, this.getOpcode16(), 65536);
                break;
            }
            case 144: {
                this.set(8, this.add8(this.get(8), -this.getDirect8(), 0));
                this.takt.inc();
                break;
            }
            case 145: {
                this.cmp8(8, this.getDirect8());
                this.takt.inc();
                break;
            }
            case 146: {
                this.set(8, this.add8(this.get(8), -this.getDirect8(), -1));
                this.takt.inc();
                break;
            }
            case 147: {
                this.addd(-this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 148: {
                this.bitop(8, this.getDirect8(), 0);
                this.takt.inc();
                break;
            }
            case 149: {
                this.bit(8, this.getDirect8());
                this.takt.inc();
                break;
            }
            case 150: {
                this.ld(8, this.getDirect8(), 256);
                this.takt.inc();
                break;
            }
            case 151: {
                this.st8(8, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 152: {
                this.bitop(8, this.getDirect8(), 1);
                this.takt.inc();
                break;
            }
            case 153: {
                this.set(8, this.add8(this.get(8), this.getDirect8(), 1));
                this.takt.inc();
                break;
            }
            case 154: {
                this.bitop(8, this.getDirect8(), 2);
                this.takt.inc();
                break;
            }
            case 155: {
                this.set(8, this.add8(this.get(8), this.getDirect8(), 0));
                this.takt.inc();
                break;
            }
            case 156: {
                this.cmp16(1, this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 157: {
                this.j(this.getDirectAdr(), true);
                this.takt.inc(3);
                break;
            }
            case 158: {
                this.ld(1, this.getDirect16(), 65536);
                this.takt.inc();
                break;
            }
            case 159: {
                this.st16(1, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 160: {
                this.set(8, this.add8(this.get(8), -this.getIndexed8(), 0));
                this.takt.inc();
                break;
            }
            case 161: {
                this.cmp8(8, this.getIndexed8());
                this.takt.inc();
                break;
            }
            case 162: {
                this.set(8, this.add8(this.get(8), -this.getIndexed8(), -1));
                this.takt.inc();
                break;
            }
            case 163: {
                this.addd(-this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 164: {
                this.bitop(8, this.getIndexed8(), 0);
                this.takt.inc();
                break;
            }
            case 165: {
                this.bit(8, this.getIndexed8());
                this.takt.inc();
                break;
            }
            case 166: {
                this.ld(8, this.getIndexed8(), 256);
                this.takt.inc();
                break;
            }
            case 167: {
                this.st8(8, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 168: {
                this.bitop(8, this.getIndexed8(), 1);
                this.takt.inc();
                break;
            }
            case 169: {
                this.set(8, this.add8(this.get(8), this.getIndexed8(), 1));
                this.takt.inc();
                break;
            }
            case 170: {
                this.bitop(8, this.getIndexed8(), 2);
                this.takt.inc();
                break;
            }
            case 171: {
                this.set(8, this.add8(this.get(8), this.getIndexed8(), 0));
                this.takt.inc();
                break;
            }
            case 172: {
                this.cmp16(1, this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 173: {
                this.j(this.getIndexedAdr(), true);
                this.takt.inc(3);
                break;
            }
            case 174: {
                this.ld(1, this.getIndexed16(), 65536);
                this.takt.inc();
                break;
            }
            case 175: {
                this.st16(1, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 176: {
                this.set(8, this.add8(this.get(8), -this.getExtended8(), 0));
                this.takt.inc();
                break;
            }
            case 177: {
                this.cmp8(8, this.getExtended8());
                this.takt.inc();
                break;
            }
            case 178: {
                this.set(8, this.add8(this.get(8), -this.getExtended8(), -1));
                this.takt.inc();
                break;
            }
            case 179: {
                this.addd(-this.getExtended16());
                this.takt.inc(2);
                break;
            }
            case 180: {
                this.bitop(8, this.getExtended8(), 0);
                this.takt.inc();
                break;
            }
            case 181: {
                this.bit(8, this.getExtended8());
                this.takt.inc();
                break;
            }
            case 182: {
                this.ld(8, this.getExtended8(), 256);
                this.takt.inc();
                break;
            }
            case 183: {
                this.st8(8, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            case 184: {
                this.bitop(8, this.getExtended8(), 1);
                this.takt.inc();
                break;
            }
            case 185: {
                this.set(8, this.add8(this.get(8), this.getExtended8(), 1));
                this.takt.inc();
                break;
            }
            case 186: {
                this.bitop(8, this.getExtended8(), 2);
                this.takt.inc();
                break;
            }
            case 187: {
                this.set(8, this.add8(this.get(8), this.getExtended8(), 0));
                this.takt.inc();
                break;
            }
            case 188: {
                this.cmp16(1, this.getExtended16());
                this.takt.inc(2);
                break;
            }
            case 189: {
                this.j(this.getOpcode16(), true);
                this.takt.inc(3);
                break;
            }
            case 190: {
                this.ld(1, this.getExtended16(), 65536);
                this.takt.inc();
                break;
            }
            case 191: {
                this.st16(1, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            case 192: {
                this.set(9, this.add8(this.get(9), -this.getOpcode(), 0));
                break;
            }
            case 193: {
                this.cmp8(9, this.getOpcode());
                break;
            }
            case 194: {
                this.set(9, this.add8(this.get(9), -this.getOpcode(), -1));
                break;
            }
            case 195: {
                this.addd(this.getOpcode16());
                this.takt.inc(2);
                break;
            }
            case 196: {
                this.bitop(9, this.getOpcode(), 0);
                break;
            }
            case 197: {
                this.bit(9, this.getOpcode());
                break;
            }
            case 198: {
                this.ld(9, this.getOpcode(), 256);
                break;
            }
            case 200: {
                this.bitop(9, this.getOpcode(), 1);
                break;
            }
            case 201: {
                this.set(9, this.add8(this.get(9), this.getOpcode(), 1));
                break;
            }
            case 202: {
                this.bitop(9, this.getOpcode(), 2);
                break;
            }
            case 203: {
                this.set(9, this.add8(this.get(9), this.getOpcode(), 0));
                break;
            }
            case 204: {
                this.ld(0, this.getOpcode16(), 65536);
                break;
            }
            case 206: {
                this.ld(3, this.getOpcode16(), 65536);
                break;
            }
            case 208: {
                this.set(9, this.add8(this.get(9), -this.getDirect8(), 0));
                this.takt.inc();
                break;
            }
            case 209: {
                this.cmp8(9, this.getDirect8());
                this.takt.inc();
                break;
            }
            case 210: {
                this.set(9, this.add8(this.get(9), -this.getDirect8(), -1));
                this.takt.inc();
                break;
            }
            case 211: {
                this.addd(this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 212: {
                this.bitop(9, this.getDirect8(), 0);
                this.takt.inc();
                break;
            }
            case 213: {
                this.bit(9, this.getDirect8());
                this.takt.inc();
                break;
            }
            case 214: {
                this.ld(9, this.getDirect8(), 256);
                this.takt.inc();
                break;
            }
            case 215: {
                this.st8(9, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 216: {
                this.bitop(9, this.getDirect8(), 1);
                this.takt.inc();
                break;
            }
            case 217: {
                this.set(9, this.add8(this.get(9), this.getDirect8(), 1));
                this.takt.inc();
                break;
            }
            case 218: {
                this.bitop(9, this.getDirect8(), 2);
                this.takt.inc();
                break;
            }
            case 219: {
                this.set(9, this.add8(this.get(9), this.getDirect8(), 0));
                this.takt.inc();
                break;
            }
            case 220: {
                this.ld(0, this.getDirect16(), 65536);
                this.takt.inc();
                break;
            }
            case 221: {
                this.st16(0, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 222: {
                this.ld(3, this.getDirect16(), 65536);
                this.takt.inc();
                break;
            }
            case 223: {
                this.st16(3, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 224: {
                this.set(9, this.add8(this.get(9), -this.getIndexed8(), 0));
                this.takt.inc();
                break;
            }
            case 225: {
                this.cmp8(9, this.getIndexed8());
                this.takt.inc();
                break;
            }
            case 226: {
                this.set(9, this.add8(this.get(9), -this.getIndexed8(), -1));
                this.takt.inc();
                break;
            }
            case 227: {
                this.addd(this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 228: {
                this.bitop(9, this.getIndexed8(), 0);
                this.takt.inc();
                break;
            }
            case 229: {
                this.bit(9, this.getIndexed8());
                this.takt.inc();
                break;
            }
            case 230: {
                this.ld(9, this.getIndexed8(), 256);
                this.takt.inc();
                break;
            }
            case 231: {
                this.st8(9, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 232: {
                this.bitop(9, this.getIndexed8(), 1);
                this.takt.inc();
                break;
            }
            case 233: {
                this.set(9, this.add8(this.get(9), this.getIndexed8(), 1));
                this.takt.inc();
                break;
            }
            case 234: {
                this.bitop(9, this.getIndexed8(), 2);
                this.takt.inc();
                break;
            }
            case 235: {
                this.set(9, this.add8(this.get(9), this.getIndexed8(), 0));
                this.takt.inc();
                break;
            }
            case 236: {
                this.ld(0, this.getIndexed16(), 65536);
                this.takt.inc();
                break;
            }
            case 237: {
                this.st16(0, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 238: {
                this.ld(3, this.getIndexed16(), 65536);
                this.takt.inc();
                break;
            }
            case 239: {
                this.st16(3, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 240: {
                this.set(9, this.add8(this.get(9), -this.getExtended8(), 0));
                this.takt.inc();
                break;
            }
            case 241: {
                this.cmp8(9, this.getExtended8());
                this.takt.inc();
                break;
            }
            case 242: {
                this.set(9, this.add8(this.get(9), -this.getExtended8(), -1));
                this.takt.inc();
                break;
            }
            case 243: {
                this.addd(this.getExtended16());
                this.takt.inc(2);
                break;
            }
            case 244: {
                this.bitop(9, this.getExtended8(), 0);
                this.takt.inc();
                break;
            }
            case 245: {
                this.bit(9, this.getExtended8());
                this.takt.inc();
                break;
            }
            case 246: {
                this.ld(9, this.getExtended8(), 256);
                this.takt.inc();
                break;
            }
            case 247: {
                this.st8(9, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            case 248: {
                this.bitop(9, this.getExtended8(), 1);
                this.takt.inc();
                break;
            }
            case 249: {
                this.set(9, this.add8(this.get(9), this.getExtended8(), 1));
                this.takt.inc();
                break;
            }
            case 250: {
                this.bitop(9, this.getExtended8(), 2);
                this.takt.inc();
                break;
            }
            case 251: {
                this.set(9, this.add8(this.get(9), this.getExtended8(), 0));
                this.takt.inc();
                break;
            }
            case 252: {
                this.ld(0, this.getExtended16(), 65536);
                this.takt.inc();
                break;
            }
            case 253: {
                this.st16(0, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            case 254: {
                this.ld(3, this.getExtended16(), 65536);
                this.takt.inc();
                break;
            }
            case 255: {
                this.st16(3, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            default: {
                System.out.println("Ung\u00fcltiger Opcode 0x" + Num.getByte(n) + " bei " + Num.getWord(this.reg[5] - 1));
            }
        }
        return false;
    }

    private boolean opcode10() {
        int n = this.getOpcode();
        switch (n) {
            case 32: {
                this.pcrel16(true);
                this.takt.inc();
                break;
            }
            case 33: {
                this.pcrel16(false);
                this.takt.inc();
                break;
            }
            case 34: {
                this.pcrel16(!(this.getCC(1) || this.getCC(4)));
                this.takt.inc();
                break;
            }
            case 35: {
                this.pcrel16(this.getCC(1) || this.getCC(4));
                this.takt.inc();
                break;
            }
            case 36: {
                this.pcrel16(!this.getCC(1));
                this.takt.inc();
                break;
            }
            case 37: {
                this.pcrel16(this.getCC(1));
                this.takt.inc();
                break;
            }
            case 38: {
                this.pcrel16(!this.getCC(4));
                this.takt.inc();
                break;
            }
            case 39: {
                this.pcrel16(this.getCC(4));
                this.takt.inc();
                break;
            }
            case 40: {
                this.pcrel16(!this.getCC(2));
                this.takt.inc();
                break;
            }
            case 41: {
                this.pcrel16(this.getCC(2));
                this.takt.inc();
                break;
            }
            case 42: {
                this.pcrel16(!this.getCC(8));
                this.takt.inc();
                break;
            }
            case 43: {
                this.pcrel16(this.getCC(8));
                this.takt.inc();
                break;
            }
            case 44: {
                this.pcrel16(this.getCC(8) == this.getCC(2));
                this.takt.inc();
                break;
            }
            case 45: {
                this.pcrel16(this.getCC(8) != this.getCC(2));
                this.takt.inc();
                break;
            }
            case 46: {
                this.pcrel16(!(this.getCC(4) || this.getCC(8) != this.getCC(2)));
                this.takt.inc();
                break;
            }
            case 47: {
                this.pcrel16(this.getCC(4) || this.getCC(8) != this.getCC(2));
                this.takt.inc();
                break;
            }
            case 63: {
                return true;
            }
            case 131: {
                this.cmp16(0, this.getOpcode16());
                this.takt.inc();
                break;
            }
            case 140: {
                this.cmp16(2, this.getOpcode16());
                this.takt.inc();
                break;
            }
            case 142: {
                this.ld(2, this.getOpcode16(), 65536);
                break;
            }
            case 147: {
                this.cmp16(0, this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 156: {
                this.cmp16(2, this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 158: {
                this.ld(2, this.getDirect16(), 65536);
                this.takt.inc();
                break;
            }
            case 159: {
                this.st16(2, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 163: {
                this.cmp16(0, this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 172: {
                this.cmp16(2, this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 174: {
                this.ld(2, this.getIndexed16(), 65536);
                this.takt.inc();
                break;
            }
            case 175: {
                this.st16(2, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 179: {
                this.cmp16(0, this.getExtended16());
                this.takt.inc(2);
                break;
            }
            case 188: {
                this.cmp16(2, this.getExtended16());
                this.takt.inc(2);
                break;
            }
            case 190: {
                this.ld(2, this.getExtended16(), 65536);
                this.takt.inc();
                break;
            }
            case 191: {
                this.st16(2, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            case 206: {
                this.ld(4, this.getOpcode16(), 65536);
                break;
            }
            case 222: {
                this.ld(4, this.getDirect16(), 65536);
                this.takt.inc();
                break;
            }
            case 223: {
                this.st16(4, this.getDirectAdr());
                this.takt.inc();
                break;
            }
            case 238: {
                this.ld(4, this.getIndexed16(), 65536);
                this.takt.inc();
                break;
            }
            case 239: {
                this.st16(4, this.getIndexedAdr());
                this.takt.inc();
                break;
            }
            case 254: {
                this.ld(4, this.getExtended16(), 65536);
                this.takt.inc();
                break;
            }
            case 255: {
                this.st16(4, this.getExtendedAdr());
                this.takt.inc();
                break;
            }
            default: {
                System.out.println("Ung\u00fcltiger Opcode 0x10 0x" + Num.getByte(n) + " bei " + Num.getWord(this.reg[5] - 2));
            }
        }
        return false;
    }

    private boolean opcode11() {
        int n = this.getOpcode();
        switch (n) {
            case 63: {
                return true;
            }
            case 131: {
                this.cmp16(3, this.getOpcode16());
                this.takt.inc();
                break;
            }
            case 140: {
                this.cmp16(4, this.getOpcode16());
                this.takt.inc();
                break;
            }
            case 147: {
                this.cmp16(3, this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 156: {
                this.cmp16(4, this.getDirect16());
                this.takt.inc(2);
                break;
            }
            case 163: {
                this.cmp16(3, this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 172: {
                this.cmp16(4, this.getIndexed16());
                this.takt.inc(2);
                break;
            }
            case 179: {
                this.cmp16(3, this.getExtended16());
                this.takt.inc(2);
                break;
            }
            case 188: {
                this.cmp16(4, this.getExtended16());
                this.takt.inc(2);
                break;
            }
            default: {
                System.out.println("Ung\u00fcltiger Opcode 0x11 0x" + Num.getByte(n) + " bei " + Num.getWord(this.reg[5] - 2));
            }
        }
        return false;
    }

    private int add8(int n, int n2, int n3) {
        int n4 = 0;
        if (this.getCC(1)) {
            n4 *= n3;
        }
        this.setCC(32, (n & 0xF) + (n2 & 0xF) + n4 > 15);
        int n5 = n + n2 + n4;
        this.setFlags(n5, 15, 256);
        return n5 & 0xFF;
    }

    private void addd(int n) {
        this.reg[0] = this.reg[0] + n;
        this.setFlags(this.reg[0], 15, 65536);
    }

    private void bitop(int n, int n2, int n3) {
        int n4 = this.get(n);
        switch (n3) {
            case 0: {
                n4 &= n2;
                break;
            }
            case 1: {
                n4 ^= n2;
                break;
            }
            case 2: {
                n4 |= n2;
                break;
            }
        }
        this.set(n, n4);
        this.setFlags(n4, 12, 256);
        this.setCC(2, false);
    }

    private void bit(int n, int n2) {
        this.setFlags(this.get(n) & n2, 12, 256);
        this.setCC(2, false);
    }

    private void clrFlags() {
        this.setCC(8, false);
        this.setCC(4, true);
        this.setCC(2, false);
        this.setCC(1, false);
    }

    private void cmp8(int n, int n2) {
        int n3 = this.get(n) - n2;
        this.setFlags(n3, 15, 256);
    }

    private void cmp16(int n, int n2) {
        int n3 = this.reg[n] - n2;
        this.setFlags(n3, 47, 65536);
    }

    private int com(int n) {
        this.setFlags(n ^= 0xFFFFFFFF, 13, 256);
        this.setCC(2, false);
        return n;
    }

    private void commem(int n) {
        this.mem.setMem(n, this.com(this.mem.getMem(n)));
    }

    private void daa() {
        int n = this.get(8);
        if ((n & 0xF) > 9) {
            n += 6;
        }
        if (n > 153) {
            n -= 160;
            this.setCC(1, true);
        } else {
            this.setCC(1, false);
        }
        this.set(8, n);
        this.setFlags(n, 12, 256);
        this.setCC(2, false);
    }

    private int inc(int n, int n2) {
        this.setFlags(n += n2, 14, 256);
        return n;
    }

    private void incmem(int n, int n2) {
        this.mem.setMem(n, this.inc(this.mem.getMem(n), n2));
    }

    private void j(int n, boolean bl) {
        if (bl) {
            this.psh16(4, this.reg[5]);
        }
        this.reg[5] = n;
    }

    private void rt(boolean bl) {
        int n = 128;
        if (bl) {
            n = this.getCC(128) ? 255 : 129;
        }
        this.pul(4, n);
    }

    private void ld(int n, int n2, int n3) {
        this.set(n, n2);
        this.setFlags(n2, 12, n3);
        this.setCC(2, false);
    }

    private void mul() {
        int n = this.get(8) * this.get(9) & 0xFFFF;
        this.setCC(4, n == 0);
        this.setCC(1, (n & 0x80) > 0);
        this.reg[0] = n;
    }

    private int neg(int n) {
        n = ~n + 1;
        this.setFlags(n, 15, 256);
        return n;
    }

    private void negmem(int n) {
        this.mem.setMem(n, this.neg(this.mem.getMem(n)));
    }

    private void psh8(int n, int n2) {
        int n3 = n;
        int n4 = this.reg[n3] - 1;
        this.reg[n3] = n4;
        this.mem.setMem(n4, n2);
    }

    private void psh16(int n, int n2) {
        int n3 = n;
        this.reg[n3] = this.reg[n3] - 2;
        this.mem.set2x8h(this.reg[n], n2);
    }

    private int pul8(int n) {
        int n2 = n;
        int n3 = this.reg[n2];
        this.reg[n2] = n3 + 1;
        return this.mem.getMem(n3);
    }

    private int pul16(int n) {
        int n2 = this.mem.get2x8h(this.reg[n]);
        int n3 = n;
        this.reg[n3] = this.reg[n3] + 2;
        return n2;
    }

    private void psh(int n, int n2) {
        if ((n2 & 0x80) > 0) {
            this.psh16(n, this.reg[5]);
        }
        if ((n2 & 0x40) > 0) {
            this.psh16(n, this.reg[n == 4 ? 3 : 4]);
        }
        if ((n2 & 0x20) > 0) {
            this.psh16(n, this.reg[2]);
        }
        if ((n2 & 0x10) > 0) {
            this.psh16(n, this.reg[1]);
        }
        if ((n2 & 8) > 0) {
            this.psh8(n, this.get(7));
        }
        if ((n2 & 4) > 0) {
            this.psh8(n, this.get(9));
        }
        if ((n2 & 2) > 0) {
            this.psh8(n, this.get(8));
        }
        if ((n2 & 1) > 0) {
            this.psh8(n, this.get(6));
        }
    }

    private void pul(int n, int n2) {
        if ((n2 & 1) > 0) {
            this.set(6, this.pul8(n));
        }
        if ((n2 & 2) > 0) {
            this.set(8, this.pul8(n));
        }
        if ((n2 & 4) > 0) {
            this.set(9, this.pul8(n));
        }
        if ((n2 & 8) > 0) {
            this.set(7, this.pul8(n));
        }
        if ((n2 & 0x10) > 0) {
            this.reg[1] = this.pul16(n);
        }
        if ((n2 & 0x20) > 0) {
            this.reg[2] = this.pul16(n);
        }
        if ((n2 & 0x40) > 0) {
            this.reg[n == 4 ? 3 : 4] = this.pul16(n);
        }
        if ((n2 & 0x80) > 0) {
            this.reg[5] = this.pul16(n);
        }
    }

    private void sex() {
        if ((this.get(9) & 0x80) == 128) {
            this.set(8, 255);
        } else {
            this.set(8, 0);
        }
    }

    private int shift(int n, int n2, int n3) {
        boolean bl;
        if (n2 == 0) {
            bl = (n & 0x80) != 0;
            n <<= 1;
            if (n3 == 2 && this.getCC(1)) {
                n |= 1;
            }
            this.setFlags(n, 2, 256);
        } else {
            bl = (n & 1) != 0;
            if (n3 == 0 && ((n >>= 1) & 0x40) > 0) {
                n |= 0x80;
            }
            if (n3 == 2 && this.getCC(1)) {
                n |= 0x80;
            }
        }
        this.setFlags(n, 12, 256);
        this.setCC(1, bl);
        return n & 0xFF;
    }

    private void shiftmem(int n, int n2, int n3) {
        int n4 = this.mem.getMem(n);
        n4 = this.shift(n4, n2, n3);
        this.mem.setMem(n, n4);
    }

    private void st8(int n, int n2) {
        int n3 = this.get(n);
        this.mem.setMem(n2, n3);
        this.setFlags(n3, 12, 256);
        this.setCC(2, false);
    }

    private void st16(int n, int n2) {
        int n3 = this.get(n);
        this.mem.set2x8h(n2, n3);
        this.setFlags(n3, 12, 65536);
        this.setCC(2, false);
    }

    private void tst(int n) {
        this.setFlags(n, 12, 256);
        this.setCC(2, false);
    }

    private void tfr(boolean bl) {
        int n = this.getOpcode();
        int n2 = this.getTfrIdx(n >> 4);
        int n3 = this.getTfrIdx(n & 0xF);
        if (n3 == -1 || n2 == -1) {
            return;
        }
        int n4 = this.get(n2);
        int n5 = this.get(n3);
        this.set(n3, n4);
        if (bl) {
            this.set(n2, n5);
        }
    }

    private int getTfrIdx(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 7;
            }
        }
        return -1;
    }

    private void pcrel8(boolean bl) {
        byte by = (byte)this.getOpcode();
        if (bl) {
            this.reg[5] = this.reg[5] + by;
            this.reg[5] = this.reg[5] & 0xFFFF;
        }
    }

    private void pcrel16(boolean bl) {
        short s = (short)this.getOpcode16();
        if (bl) {
            this.reg[5] = this.reg[5] + s;
            this.reg[5] = this.reg[5] & 0xFFFF;
        }
    }

    private void pcrelSR(boolean bl) {
        short s = bl ? (short)this.getOpcode16() : (short)((byte)this.getOpcode());
        this.psh16(4, this.reg[5]);
        this.reg[5] = this.reg[5] + s;
        this.reg[5] = this.reg[5] & 0xFFFF;
    }

    private int getOpcode() {
        int n = this.reg[5];
        this.reg[5] = n + 1;
        return this.mem.getMem(n);
    }

    private int getOpcode16() {
        int n = this.getOpcode() << 8;
        return n |= this.getOpcode();
    }

    private int getDirectAdr() {
        return this.reg[7] << 8 | this.getOpcode();
    }

    private int getDirect8() {
        return this.mem.getMem(this.getDirectAdr());
    }

    private int getDirect16() {
        return this.mem.get2x8h(this.getDirectAdr());
    }

    private void setDirect8(int n) {
        this.mem.setMem(this.getDirectAdr(), n);
    }

    private int getExtendedAdr() {
        return this.getOpcode16();
    }

    private int getExtended8() {
        return this.mem.getMem(this.getExtendedAdr());
    }

    private int getExtended16() {
        return this.mem.get2x8h(this.getExtendedAdr());
    }

    private void setExtended8(int n) {
        this.mem.setMem(this.getExtendedAdr(), n);
    }

    private int getIndexedAdr() {
        int n = this.getOpcode();
        int n2 = ((n & 0x60) >> 5) + 1;
        int n3 = 0;
        if ((n & 0x80) == 0) {
            int n4 = n & 0x1F;
            if ((n4 & 0x10) != 0) {
                n4 -= 32;
            }
            this.takt.inc();
            n3 = this.reg[n2] + n4;
        } else {
            boolean bl = (n & 0x10) == 0;
            switch (n & 0xF) {
                case 0: {
                    if (bl) {
                        int n5 = n2;
                        int n6 = this.reg[n5];
                        this.reg[n5] = n6 + 1;
                        n3 = n6;
                        this.takt.inc(2);
                        break;
                    }
                    n3 = -1;
                    break;
                }
                case 1: {
                    n3 = this.reg[n2];
                    int n7 = n2;
                    this.reg[n7] = this.reg[n7] + 2;
                    this.takt.inc(3);
                    break;
                }
                case 2: {
                    if (bl) {
                        int n8 = n2;
                        int n9 = this.reg[n8] - 1;
                        this.reg[n8] = n9;
                        n3 = n9;
                        this.takt.inc(2);
                        break;
                    }
                    n3 = -1;
                    break;
                }
                case 3: {
                    int n10 = n2;
                    this.reg[n10] = this.reg[n10] - 2;
                    n3 = this.reg[n2];
                    this.takt.inc(3);
                    break;
                }
                case 4: {
                    n3 = this.reg[n2];
                    break;
                }
                case 5: {
                    n3 = this.get(9) + this.reg[n2];
                    this.takt.inc();
                    break;
                }
                case 6: {
                    n3 = this.get(8) + this.reg[n2];
                    this.takt.inc();
                    break;
                }
                case 7: {
                    n3 = -1;
                    break;
                }
                case 8: {
                    n3 = this.reg[n2] + this.getOpcode();
                    break;
                }
                case 9: {
                    n3 = this.reg[n2] + this.getOpcode16();
                    this.takt.inc();
                    break;
                }
                case 10: {
                    n3 = -1;
                    break;
                }
                case 11: {
                    n3 = this.reg[n2] + this.reg[0];
                    this.takt.inc(2);
                    break;
                }
                case 12: {
                    n3 = this.reg[5] + this.getOpcode();
                    break;
                }
                case 13: {
                    n3 = this.reg[5] + this.getOpcode16();
                    this.takt.inc(3);
                    break;
                }
                case 14: {
                    n3 = -1;
                    break;
                }
                case 15: {
                    if (bl) {
                        n3 = -1;
                        break;
                    }
                    n3 = this.getOpcode16();
                    break;
                }
            }
            if (!bl && n3 != -1) {
                n3 = this.mem.get2x8h(n3);
                this.takt.inc();
            }
        }
        return n3;
    }

    private int getIndexed8() {
        return this.mem.getMem(this.getIndexedAdr());
    }

    private int getIndexed16() {
        return this.mem.get2x8h(this.getIndexedAdr());
    }

    private void setIndexed8(int n) {
        this.mem.setMem(this.getIndexedAdr(), n);
    }

    private void setFlags(int n, int n2, int n3) {
        if ((n2 & 8) > 0) {
            this.setCC(8, (n & n3 >> 1) > 0);
        }
        if ((n2 & 4) > 0) {
            this.setCC(4, n == 0);
        }
        if ((n2 & 2) > 0) {
            if (n3 == 256) {
                this.setCC(2, n > 127 || n < -128);
            } else {
                this.setCC(2, n > 32727 || n < 32728);
            }
        }
        if ((n2 & 1) > 0) {
            this.setCC(1, (n & n3) > 0);
        }
    }

    private int get(int n) {
        if (n == 8) {
            return this.reg[0] >> 8;
        }
        if (n == 9) {
            return this.reg[0] & 0xFF;
        }
        if (n >= 0 && n <= 7) {
            return this.reg[n];
        }
        return -1;
    }

    private void set(int n, int n2) {
        if (n == 8) {
            this.reg[0] = (n2 << 8 | this.reg[0] & 0xFF) & 0xFFFF;
        } else if (n == 9) {
            this.reg[0] = n2 & 0xFF | this.reg[0] & 0xFF00;
        } else if (n >= 0 && n <= 5) {
            this.reg[n] = n2 & 0xFFFF;
        } else if (n == 7 || n == 6) {
            this.reg[n] = n2 & 0xFF;
        }
    }

    private boolean getCC(int n) {
        return (this.reg[6] & n) == n;
    }

    private void setCC(int n, boolean bl) {
        this.reg[6] = bl ? this.reg[6] | n : this.reg[6] & ~n;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == Taste.TASTE_UP) {
            if (actionEvent.getActionCommand().equals("f4")) {
                this.breakPressed = true;
            }
            if (actionEvent.getActionCommand().equals("reset")) {
                this.breakPressed = true;
            }
        }
    }

    public Emulator(Rechner rechner) {
        this.rechner = rechner;
        rechner.setEmulator(this);
        this.mem = rechner.getSpeicher();
        this.takt = this.mem.getTakt();
    }
}

