/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp;

class Parallel {
    private static final int SF_INPUT = 0;
    private static final int SF_OUTPUT = 1;
    private static final int SF_INT_FALL = 2;
    private static final int SF_INT_RISE = 3;
    private static final int SF_HS_READ = 4;
    private static final int SF_HS_WRITE = 5;
    private static final int SF_S_INT = 6;
    private static final int SF_S_CYCLE = 7;
    private static final int SF_INT_FALL_DIS = 8;
    private static final int SF_INT_RISE_DIS = 9;
    private static final int SF_INT_FALL_WAIT = 10;
    private static final int SF_INT_RISE_WAIT = 11;
    private boolean alwaysReadHardware;
    private int dataRegister;
    private int dataDirectionRegister;
    private short[] dataBuffer;
    private int[] specialFunction;
    private short[] specialData;

    public Parallel(int n, int n2) {
        if (n > 32) {
            n = 32;
        }
        if (n2 > 32) {
            n2 = 32;
        }
        this.dataBuffer = new short[n];
        this.specialFunction = new int[n2];
        this.specialData = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.specialData[n3] = -1;
            ++n3;
        }
    }

    public final void regSetData(int n) {
        this.dataRegister = n;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.dataBuffer.length) {
            if ((this.dataDirectionRegister & n2) > 0) {
                this.dataBuffer[n3] = (this.dataRegister & n2) > 0 ? (short)1 : 0;
            }
            n2 <<= 1;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.specialFunction.length) {
            if (this.specialFunction[n4] == 5) {
                this.specialData[n4] = 1;
            }
            ++n4;
        }
        this.debugChangeHW();
    }

    public final int regGetData() {
        int n;
        int n2 = this.dataRegister;
        int n3 = 1;
        if (this.alwaysReadHardware) {
            n = 0;
            while (n < this.dataBuffer.length) {
                if ((n3 & this.dataDirectionRegister) == 1) {
                    switch (this.dataBuffer[n]) {
                        case 0: {
                            n2 &= ~n3;
                            break;
                        }
                        case 1: {
                            n2 |= n3;
                            break;
                        }
                    }
                }
                n3 <<= 1;
                ++n;
            }
        }
        n = 0;
        while (n < this.specialFunction.length) {
            if (this.specialFunction[n] == 4) {
                this.specialData[n] = 1;
            }
            ++n;
        }
        this.debugChangeHW();
        return n2;
    }

    public final void regSetDataDirection(int n) {
    }

    public final int regGetDataDirection() {
        return this.dataDirectionRegister;
    }

    public final void regSetSpecialFunction(int n, int n2) {
        if (n < this.specialFunction.length) {
            switch (n2) {
                default: 
            }
            return;
        }
    }

    public final int regGetSpecialFunction(int n) {
        if (n < this.specialFunction.length) {
            return this.specialFunction[n];
        }
        return -1;
    }

    public final void regSetSpeicalRegister(int n, boolean bl) {
        if (n < this.specialFunction.length) {
            switch (this.specialFunction[n]) {
                default: 
            }
            return;
        }
    }

    public final int regGetSpecialRegister(int n) {
        if (n < this.specialFunction.length) {
            return this.specialData[n];
        }
        return -1;
    }

    public final short[] hwGetData() {
        short[] sArray = new short[this.dataBuffer.length];
        int n = 0;
        while (n < this.dataBuffer.length) {
            sArray[n] = this.dataBuffer[n];
            ++n;
        }
        return sArray;
    }

    public final void hwSetData(short[] sArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < this.dataBuffer.length) {
            this.dataBuffer[n2] = n2 < sArray.length ? sArray[n2] : -1;
            if ((n & this.dataDirectionRegister) == 0) {
                switch (sArray[n2]) {
                    case 0: {
                        this.dataRegister &= ~n;
                        break;
                    }
                    case 1: {
                        this.dataRegister |= n;
                        break;
                    }
                }
            }
            n <<= 1;
            ++n2;
        }
    }

    public final short hwGetSpecial(int n) {
        if (n < this.specialData.length) {
            return this.specialData[n];
        }
        return -1;
    }

    public final void hwSetSpecial(int n, short s) {
        if (n < this.specialData.length && (s == 0 || s == 1 || s == -1) && s != this.specialData[n]) {
            switch (this.specialFunction[n]) {
                case 0: 
                case 10: 
                case 11: {
                    this.specialData[n] = s;
                    return;
                }
                case 2: {
                    this.specialData[n] = s;
                    if (s != 0) break;
                    this.doInterrupt();
                    return;
                }
                case 3: {
                    this.specialData[n] = s;
                    if (s != 1) break;
                    this.doInterrupt();
                    return;
                }
                case 8: {
                    this.specialData[n] = s;
                    if (s != 0) break;
                    this.specialFunction[n] = 10;
                    return;
                }
                case 9: {
                    this.specialData[n] = s;
                    if (s != 1) break;
                    this.specialFunction[n] = 11;
                    return;
                }
            }
        }
    }

    private final void doInterrupt() {
    }

    private final void debugChangeHW() {
    }
}

