/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp;

import feu.mrp.Emulator;
import feu.mrp.SegmentSpeicherbereich;
import feu.mrp.TastaturSpeicherbereich;
import feu.mrp.memory.Speicher;
import feu.mrp.memory.StreamROM;

public class Rechner {
    public static final int AD0 = 117;
    public static final int DISPLY = 128;
    public static final int CURSOR = 144;
    public static final int BRKBYT = 154;
    public static final int UMCDTB = 160;
    public static final int SLANF = 198;
    public static final int SLEND = 200;
    public static final int SLANZ = 202;
    public static final int LOFFSET = 204;
    public static final int SLFLAG = 206;
    public static final int BRKADR = 240;
    public static final int SPREG = 242;
    public static final int CCREG = 244;
    public static final int AREG = 245;
    public static final int BREG = 246;
    public static final int DPREG = 247;
    public static final int XREG = 248;
    public static final int YREG = 250;
    public static final int UREG = 252;
    public static final int PCREG = 254;
    public static final int KEY0 = 61456;
    public static final int DISP = 61472;
    public static final int RAMLEN = 8192;
    public static final int RAM0POS = 0;
    protected MrpSpeicher speicher;
    protected Emulator emulator;

    public final Speicher getSpeicher() {
        return this.speicher;
    }

    public final TastaturSpeicherbereich getTastaturSpeicher() {
        return this.speicher.tastaturSpeicher;
    }

    public final SegmentSpeicherbereich getSegmentSpeicher() {
        return this.speicher.segmentSpeicher;
    }

    public final StreamROM getRomSpeicher() {
        return this.speicher.rom;
    }

    public final void setEmulator(Emulator emulator) {
        this.emulator = emulator;
    }

    public final void debugWrite() {
        if (this.emulator != null) {
            this.emulator.debugWrite();
        }
        System.out.println();
    }

    public final void clearDisplay() {
        int n = 61472;
        while (n < 61488) {
            this.speicher.setMem(n++, 0);
        }
    }

    public final void viewText(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            this.viewChar(string.charAt(n), bl);
            ++n;
        }
    }

    public final void viewChar(char c, boolean bl) {
        if (c >= '0' && c <= '9') {
            this.setAsciiBuffer(c - 48);
        } else if (c >= 'a' && c <= 'z') {
            this.setAsciiBuffer(c - 97 + 10);
        } else if (c >= 'A' && c <= 'Z') {
            this.setAsciiBuffer(c - 65 + 10);
        } else if (c == ' ') {
            this.setAsciiBuffer(36);
        } else if (c == '\r') {
            this.speicher.setMem(144, 0);
        } else if (c == '\n') {
            int n = 128;
            while (n < 136) {
                this.speicher.setMem(n, 36);
                ++n;
            }
        } else if (c != '\b') {
            if (c == '\t') {
                if (this.speicher.getMem(144) < 2) {
                    this.speicher.setMem(144, 2);
                } else if (this.speicher.getMem(144) < 6) {
                    this.speicher.setMem(144, 6);
                } else {
                    this.speicher.setMem(144, 8);
                }
            } else {
                this.setAsciiBuffer(37);
            }
        }
        this.asciiRefresh(bl);
    }

    private final void setAsciiBuffer(int n) {
        int n2 = this.speicher.getMem(144);
        if (n2 >= 0 && n2 < 8) {
            this.speicher.setMem(128 + n2, n);
            this.speicher.setMem(144, ++n2);
        }
    }

    private final void asciiRefresh(boolean bl) {
        int n = 0;
        while (n < 8) {
            int n2 = this.speicher.getMem(160 + this.speicher.getMem(128 + n));
            if (n == this.speicher.getMem(144)) {
                n2 |= 0x80;
            }
            this.speicher.setMem(61479 - n, n2);
            this.speicher.setMem(61487 - n, bl ? n2 : 0);
            ++n;
        }
    }

    public void reset() {
        int n = 0;
        while (n < 256) {
            this.speicher.setMem(n, this.speicher.getMem(n + 61184));
            ++n;
        }
        this.clearDisplay();
        this.viewText("\r\nFu 2007A", false);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.speicher + "]";
    }

    public Rechner() {
        Rechner rechner = this;
        if (rechner == null) {
            throw null;
        }
        this.speicher = rechner.new MrpSpeicher();
        this.emulator = null;
    }

    private final class MrpSpeicher
    extends Speicher {
        StreamROM rom = new StreamROM("/feu/rom70b.rom");
        TastaturSpeicherbereich tastaturSpeicher = new TastaturSpeicherbereich();
        SegmentSpeicherbereich segmentSpeicher = new SegmentSpeicherbereich();

        protected final boolean translateToCurrent(int n) {
            if (n < 8192 && n >= 0) {
                return false;
            }
            if (n >= 61440 && n < 61696) {
                if (n >= 61472 && n < 61488) {
                    this.curAdr = n - 61472;
                    this.curSpeicher = this.segmentSpeicher;
                } else if (n >= 61456 && n < 61464) {
                    this.curAdr = n - 61456;
                    this.curSpeicher = this.tastaturSpeicher;
                } else {
                    this.curSpeicher = null;
                }
            } else if (n >= 57344 && n <= 65535) {
                this.curAdr = n - 57344;
                this.curSpeicher = this.rom;
            } else {
                this.curSpeicher = null;
            }
            return true;
        }

        protected void debugWrite() {
            Rechner.this.debugWrite();
        }

        public MrpSpeicher() {
            super(8192, 255);
        }
    }
}

