/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp.memory;

import feu.mrp.memory.Speicher;
import hydro.Num;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class MemoryView
extends TextArea {
    private Speicher mem;
    private int from;
    private int to;
    private int bytes;
    private int reihen;
    private int adrlen;
    private int byteanz;
    private int updateTime = 10;
    private boolean updateNeeded = false;
    private StringBuffer inhalt;
    private Thread updateThread;
    private MemListener memListener;

    protected void finalize() throws Throwable {
        this.mem.removeSetListener(this.memListener);
        this.updateThread.stop();
        super.finalize();
    }

    private void createLine(int n, boolean bl) {
        int n2 = n * this.byteanz + this.from;
        int n3 = this.adrlen - 1;
        while (n3 >= 0) {
            this.inhalt.append(Num.getNibble(n2, n3));
            --n3;
        }
        this.inhalt.append(' ');
        n3 = 0;
        while (n3 < this.byteanz) {
            n2 = n * this.byteanz + n3 + this.from;
            this.inhalt.append(' ');
            int n4 = this.mem.getMem(n2);
            int n5 = this.bytes - 2;
            while (n5 >= 0) {
                this.inhalt.append(Num.getNibble(n4, n5));
                --n5;
            }
            ++n3;
        }
        if (bl) {
            this.inhalt.append('\n');
        }
    }

    public Point getCaretAddress() {
        int n = this.adrlen + this.byteanz * this.bytes + 2;
        int n2 = this.getCaretPosition();
        int n3 = n2 / n;
        int n4 = n2 % n;
        if (n4 < this.adrlen + 1) {
            return null;
        }
        n3 *= this.byteanz;
        n3 += this.from;
        if ((n4 -= this.adrlen + 1) % this.bytes == 0) {
            return null;
        }
        return new Point(n3 + n4 / this.bytes, this.bytes - n4 % this.bytes - 1);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.charWidth(' ') * (this.adrlen + 2 + this.bytes * this.byteanz) + 40;
        int n2 = fontMetrics.getHeight() * this.getRows() + fontMetrics.getMaxAscent();
        return new Dimension(n, n2);
    }

    public void setUpdateTime(int n) {
        if (n >= 0) {
            this.updateTime = n;
        }
    }

    private synchronized void updateInhalt() {
        try {
            while (!this.updateNeeded) {
                this.wait();
            }
            int n = this.getCaretPosition();
            this.setText(this.inhalt.toString());
            this.setCaretPosition(n);
            this.updateNeeded = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void doKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t') {
            if (keyEvent.getModifiers() == 1) {
                this.lastPos();
            } else if (keyEvent.getModifiers() == 0) {
                this.nextPos();
            } else {
                return;
            }
            keyEvent.consume();
            return;
        }
        int n = Character.getNumericValue(keyEvent.getKeyChar());
        if (n < 0 || n > 15) {
            return;
        }
        Point point = this.getCaretAddress();
        if (point != null) {
            int n2 = this.mem.getMem(point.x);
            n2 = n2 & ~(15 << point.y * 4) | n << point.y * 4;
            this.mem.setMem(point.x, n2);
            int n3 = 1;
            if (point.y == 0) {
                ++n3;
                if (point.x % this.byteanz == this.byteanz - 1) {
                    n3 += this.adrlen + 2;
                }
            }
            this.setCaretPosition(this.getCaretPosition() + n3);
        }
        keyEvent.consume();
    }

    private void lastPos() {
        Point point = this.getCaretAddress();
        while (point != null) {
            this.setCaretPosition(this.getCaretPosition() - 1);
            point = this.getCaretAddress();
        }
        while (point == null) {
            if (this.getCaretPosition() == 0) {
                return;
            }
            this.setCaretPosition(this.getCaretPosition() - 1);
            point = this.getCaretAddress();
        }
        while (point != null) {
            this.setCaretPosition(this.getCaretPosition() - 1);
            point = this.getCaretAddress();
        }
        this.setCaretPosition(this.getCaretPosition() + 1);
    }

    private void nextPos() {
        Point point = this.getCaretAddress();
        while (point != null) {
            this.setCaretPosition(this.getCaretPosition() + 1);
            point = this.getCaretAddress();
        }
        while (point == null) {
            if (this.getCaretPosition() == this.inhalt.length()) {
                return;
            }
            this.setCaretPosition(this.getCaretPosition() + 1);
            point = this.getCaretAddress();
        }
    }

    private synchronized void doMemoryEvent(ActionEvent actionEvent) {
        int n;
        String string = new String();
        int n2 = this.bytes - 2;
        while (n2 >= 0) {
            string = string + Num.getNibble(actionEvent.getModifiers(), n2);
            --n2;
        }
        n2 = (actionEvent.getID() - this.from) / this.byteanz;
        int n3 = n2 * (this.adrlen + 2 + this.byteanz * this.bytes) + this.adrlen + 2 + this.bytes * (n = actionEvent.getID() % this.byteanz);
        if (n3 > 0 && n3 < this.inhalt.length()) {
            int n4 = this.bytes - 2;
            while (n4 >= 0) {
                this.inhalt.setCharAt(n3++, Num.getNibble(actionEvent.getModifiers(), n4));
                --n4;
            }
            this.updateNeeded = true;
            this.notify();
        }
    }

    public MemoryView(Speicher speicher, int n, int n2) {
        this(speicher, 2, 4, 16, n, n2);
    }

    public MemoryView(Speicher speicher, int n, int n2, int n3, int n4, int n5) {
        super("", 20, n2 + 2 + n * (n3 + 1), 1);
        this.byteanz = n3;
        this.from = n4 / n3 * n3;
        this.to = n5;
        this.mem = speicher;
        this.adrlen = n2;
        this.bytes = n + 1;
        this.reihen = (n5 - this.from + n3 - 1) / n3;
        this.setEditable(false);
        this.setFont(new Font("Monospaced", 0, 12));
        this.inhalt = new StringBuffer();
        this.inhalt.ensureCapacity(this.reihen * (n2 + 2 + n * n3));
        int n6 = 0;
        while (n6 < this.reihen) {
            this.createLine(n6, n6 < this.reihen - 1);
            ++n6;
        }
        this.setText(this.inhalt.toString());
        MemoryView memoryView = this;
        if (memoryView == null) {
            throw null;
        }
        this.addKeyListener(memoryView.new EditListener());
        MemoryView memoryView2 = this;
        if (memoryView2 == null) {
            throw null;
        }
        this.memListener = memoryView2.new MemListener();
        speicher.addSetListener(this.memListener);
        MemoryView memoryView3 = this;
        if (memoryView3 == null) {
            throw null;
        }
        this.updateThread = memoryView3.new UpdateThread();
        this.updateThread.setPriority(1);
        this.updateThread.start();
    }

    class EditListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            MemoryView.this.doKeyEvent(keyEvent);
        }

        EditListener() {
        }
    }

    class MemListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getID() >= MemoryView.this.from && actionEvent.getID() < MemoryView.this.to) {
                MemoryView.this.doMemoryEvent(actionEvent);
            }
        }

        MemListener() {
        }
    }

    private class UpdateThread
    extends Thread {
        public void run() {
            try {
                while (!MemoryView.this.isValid()) {
                    this.wait();
                }
            }
            catch (Exception exception) {}
            while (true) {
                MemoryView.this.updateInhalt();
                try {
                    Thread.sleep(MemoryView.this.updateTime);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        UpdateThread() {
        }
    }
}

