/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp.memory;

import feu.mrp.TaktZaehler;
import feu.mrp.memory.Speicherbereich;
import hydro.Num;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;

public abstract class Speicher
implements Speicherbereich {
    public static final String GET = "get";
    public static final String SET = "set";
    private ActionListener getListener;
    private ActionListener setListener;
    private TaktZaehler takt = new TaktZaehler();
    private int[] fastMem;
    private int fastMemLen;
    private int fastMask;
    protected Speicherbereich curSpeicher;
    protected int curAdr;

    public final TaktZaehler getTakt() {
        return this.takt;
    }

    public final void addGetListener(ActionListener actionListener) {
        this.getListener = AWTEventMulticaster.add(this.getListener, actionListener);
    }

    public final void removeGetListener(ActionListener actionListener) {
        this.getListener = AWTEventMulticaster.remove(this.getListener, actionListener);
    }

    private final void processGetEvent(int n) {
        this.getListener.actionPerformed(new ActionEvent(this, n, GET));
    }

    public final void addSetListener(ActionListener actionListener) {
        this.setListener = AWTEventMulticaster.add(this.setListener, actionListener);
    }

    public final void removeSetListener(ActionListener actionListener) {
        this.setListener = AWTEventMulticaster.remove(this.setListener, actionListener);
    }

    private final void processSetEvent(int n, int n2) {
        this.setListener.actionPerformed(new ActionEvent(this, n, SET, n2));
    }

    protected abstract boolean translateToCurrent(int var1);

    protected abstract void debugWrite();

    public final void debugLine(int n, int n2) {
        n -= n % 16;
        int n3 = 0;
        while (n3 < n2) {
            System.out.print(Num.getWord(n + 16 * n3) + "   ");
            int n4 = 0;
            while (n4 < 16) {
                System.out.print(Num.getByte(this.getMem(n + 16 * n3 + n4)) + " ");
                ++n4;
            }
            System.out.println();
            ++n3;
        }
    }

    public final int getMem(int n) {
        if (n < 0 || n > 65535) {
            System.out.println("falsche Adresse " + n + ": " + Num.getWord(n));
            this.debugWrite();
        }
        this.takt.inc();
        if (this.getListener != null) {
            this.processGetEvent(n);
        }
        if (this.translateToCurrent(n)) {
            return this.curSpeicher == null ? -1 : this.curSpeicher.getMem(this.curAdr);
        }
        return this.fastMem[n];
    }

    public final synchronized void setMem(int n, int n2) {
        this.takt.inc();
        if (this.translateToCurrent(n)) {
            if (this.curSpeicher != null) {
                this.curSpeicher.setMem(this.curAdr, n2);
            }
        } else {
            this.fastMem[n] = n2 & this.fastMask;
        }
        if (this.setListener != null) {
            this.processSetEvent(n, n2);
        }
    }

    public final synchronized void memChanged(int n) {
        if (this.setListener != null) {
            this.processSetEvent(n, this.getMem(n));
        }
    }

    public final int get2x8h(int n) {
        int n2 = this.getMem(n++);
        int n3 = this.getMem(n);
        return n2 << 8 | n3;
    }

    public final int get2x8l(int n) {
        int n2 = this.getMem(n++);
        int n3 = this.getMem(n);
        return n3 << 8 | n2;
    }

    public final synchronized void set2x8h(int n, int n2) {
        this.setMem(n++, n2 >> 8 & 0xFF);
        this.setMem(n, n2 & 0xFF);
    }

    public final synchronized void set2x8l(int n, int n2) {
        this.setMem(n++, n2 & 0xFF);
        this.setMem(n, n2 >> 8 & 0xFF);
    }

    public Speicher(int n, int n2) {
        this.fastMemLen = n;
        this.fastMask = n2;
        this.fastMem = new int[n];
        Random random = new Random();
        int n3 = 0;
        while (n3 < n) {
            this.fastMem[n3] = random.nextInt() & n2;
            ++n3;
        }
    }
}

