/*
 * Decompiled with CFR 0.152.
 */
package fakerechner;

import fakerechner.FakeDialog;
import fakerechner.FakeRechner;
import hydro.HexView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import mrp.TaktZaehler;
import mrp.awt.Rechner;
import mrp.memory.EventSpeicher;
import mrp.memory.Speicher;
import mrp.memory.Speicherbereich;

public class Emulator
implements ActionListener {
    static final int REGD = 0;
    static final int REGX = 1;
    static final int REGY = 2;
    static final int REGS = 3;
    static final int REGU = 4;
    static final int REGPC = 5;
    static final int REGCC = 6;
    static final int REGDP = 7;
    static final int REGA = 8;
    static final int REGB = 9;
    static final int FLAG_E = 128;
    static final int FLAG_F = 64;
    static final int FLAG_H = 32;
    static final int FLAG_I = 16;
    static final int FLAG_N = 8;
    static final int FLAG_Z = 4;
    static final int FLAG_V = 2;
    static final int FLAG_C = 1;
    static final int FLAG_COMPUTE = 15;
    static final int CMASK8 = 256;
    static final int CMASK16 = 65536;
    Rechner rechner;
    EventSpeicher mem;
    TaktZaehler takt;
    int[] reg = new int[8];
    boolean breakPressed = false;

    public void init() {
        this.reg[0] = Speicher.get2x8((Speicherbereich)this.mem, (int)245, (boolean)true);
        this.reg[1] = Speicher.get2x8((Speicherbereich)this.mem, (int)248, (boolean)true);
        this.reg[2] = Speicher.get2x8((Speicherbereich)this.mem, (int)250, (boolean)true);
        this.reg[3] = Speicher.get2x8((Speicherbereich)this.mem, (int)242, (boolean)true);
        this.reg[4] = Speicher.get2x8((Speicherbereich)this.mem, (int)252, (boolean)true);
        this.reg[5] = Speicher.get2x8((Speicherbereich)this.mem, (int)254, (boolean)true);
        this.reg[6] = this.mem.getMem(244);
        this.reg[7] = this.mem.getMem(247);
        this.rechner.getTastatur().addActionListener((ActionListener)this);
    }

    public void exit() {
        this.rechner.getTastatur().removeActionListener((ActionListener)this);
        Speicher.set2x8((Speicherbereich)this.mem, (int)245, (int)this.reg[0], (boolean)true);
        Speicher.set2x8((Speicherbereich)this.mem, (int)248, (int)this.reg[1], (boolean)true);
        Speicher.set2x8((Speicherbereich)this.mem, (int)250, (int)this.reg[2], (boolean)true);
        Speicher.set2x8((Speicherbereich)this.mem, (int)242, (int)this.reg[3], (boolean)true);
        Speicher.set2x8((Speicherbereich)this.mem, (int)252, (int)this.reg[4], (boolean)true);
        Speicher.set2x8((Speicherbereich)this.mem, (int)254, (int)this.reg[5], (boolean)true);
        this.mem.setMem(244, this.reg[6]);
        this.mem.setMem(247, this.reg[7]);
    }

    public void run() {
        this.takt.setStartTime();
        while (!this.step() && !this.breakPressed) {
        }
        this.takt.setStopTime();
        FakeDialog.ok((String)(this.takt.getTakteTime() + " Takte mit " + this.takt.getFrequenzKHz() + " KHz abgearbeitet."));
    }

    public synchronized boolean step() {
        int n = this.getOpcode();
        switch (n) {
            case 18: {
                break;
            }
            case 32: {
                this.pcrel8();
                this.takt.inc();
                break;
            }
            case 58: {
                this.reg[1] = this.reg[1] + this.get(9);
                this.takt.inc(2);
                break;
            }
            case 63: {
                return true;
            }
            case 72: {
                this.set(8, this.asl(this.get(8), 256));
                break;
            }
            case 88: {
                this.set(9, this.asl(this.get(9), 256));
                break;
            }
            case 126: {
                this.reg[5] = this.getOpcode16();
                break;
            }
            case 137: {
                this.set(8, this.add8(this.get(8), this.getImm8(), true));
                break;
            }
            case 153: {
                this.set(8, this.add8(this.get(8), this.getDirect8(), true));
                this.takt.inc();
                break;
            }
            case 201: {
                this.set(9, this.add8(this.get(9), this.getImm8(), true));
                break;
            }
            case 217: {
                this.set(9, this.add8(this.get(9), this.getDirect8(), true));
                this.takt.inc();
                break;
            }
            default: {
                int n2 = this.reg[5];
                this.reg[5] = n2 - 1;
                int n3 = n2;
                FakeDialog.ok((String)("Ung\u00fcltiger Opcode " + HexView.getByte((int)n) + " an Adresse " + HexView.getWord((int)n3)));
            }
        }
        return false;
    }

    private int add8(int n, int n2, boolean bl) {
        int n3 = 0;
        if (bl && this.getCC(1)) {
            n3 = 1;
        }
        this.setCC(32, (n & 0xF) + (n2 & 0xF) + n3 > 15);
        int n4 = n + n2 + n3;
        this.setFlags(n4, 15, 256);
        return n4 & 0xFF;
    }

    private int asl(int n, int n2) {
        this.setFlags(n >>= 1, 15, n2);
        n = n2 == 256 ? (n &= 0xFF) : (n &= 0xFFFF);
        return n;
    }

    private void pcrel8() {
        byte by = (byte)this.getOpcode();
        this.reg[5] = this.reg[5] + by;
    }

    private int getOpcode() {
        int n = this.reg[5];
        this.reg[5] = n + 1;
        return this.mem.getMem(n);
    }

    private int getOpcode16() {
        int n = this.getOpcode() << 8;
        return n |= this.getOpcode();
    }

    private int getImm8() {
        return this.getOpcode();
    }

    private int getImm16() {
        return this.getOpcode16();
    }

    private int getDirectAdr() {
        return (this.reg[7] << 8) + this.getOpcode();
    }

    private int getDirect8() {
        return this.mem.getMem(this.getDirectAdr());
    }

    private int getDirect16() {
        return Speicher.get2x8((Speicherbereich)this.mem, (int)this.getDirectAdr(), (boolean)true);
    }

    private void setFlags(int n, int n2, int n3) {
        if ((n2 & 8) > 0) {
            this.setCC(8, (n & n3 >> 1) > 0);
        }
        if ((n2 & 4) > 0) {
            this.setCC(4, n == 0);
        }
        if ((n2 & 2) > 0) {
            if (n3 == 256) {
                this.setCC(2, n > 127 || n < -128);
            } else {
                this.setCC(2, n > 32727 || n < 32728);
            }
        }
        if ((n2 & 1) > 0) {
            this.setCC(1, (n & n3) > 0);
        }
    }

    private int get(int n) {
        if (n >= 0 && n <= 7) {
            return this.reg[n];
        }
        if (n == 8) {
            return this.reg[0] >> 8;
        }
        if (n == 9) {
            return this.reg[0] & 0xFF;
        }
        return -1;
    }

    private void set(int n, int n2) {
        if (n >= 0 && n <= 5) {
            this.reg[n] = n2 & 0xFFFF;
        } else if (n >= 7 && n <= 9) {
            n2 &= 0xFF;
            if (n == 8) {
                n2 <<= 8;
                this.reg[0] = n2 |= this.reg[0] & 0xFF;
            } else if (n == 9) {
                this.reg[0] = n2 |= this.reg[0] & 0xFF00;
            } else {
                this.reg[n] = n2;
            }
        }
    }

    private boolean getCC(int n) {
        return (this.reg[6] & n) == n;
    }

    private void setCC(int n, boolean bl) {
        this.reg[6] = bl ? this.reg[6] | n : this.reg[6] & ~n;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 2001 && actionEvent.getActionCommand().equals("f4")) {
            this.breakPressed = true;
        }
    }

    public Emulator() {
        this.rechner = FakeRechner.fakeRechner.rechner;
        this.mem = this.rechner.getSpeicher();
        this.takt = this.mem.getTakt();
    }
}

