/*
 * Decompiled with CFR 0.152.
 */
package feu.fakerechner;

import feu.fakerechner.FakeApplet;
import feu.fakerechner.FakeDialog;
import feu.fakerechner.Funktionen;
import feu.fakerechner.MemoryWindow;
import feu.fakerechner.RegisterWindow;
import feu.fakerechner.RunWindow;
import feu.mrp.HexReader;
import feu.mrp.awt.Rechner;
import feu.mrp.memory.Speicher;
import feu.mrp.memory.StreamROM;
import hydro.Hthread;
import hydro.Num;
import hydro.awt.HDialog;
import hydro.awt.HImage;
import hydro.awt.Hawt;
import hydro.awt.Hframe;
import hydro.awt.Hgrid;
import hydro.awt.Taste;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.LineNumberReader;

public class FakeRechner
extends Hframe {
    static final String MSGABOUT = "Fake-Rechner";
    static final String MSGVER = "v0.09.004";
    static final String MSGCOPY = "by J\u00f6rg Wirtgen (wirtgen@webfabrik.de)";
    static final String MSGSYS = "System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
    static final String MSGJVM0 = System.getProperty("java.version");
    static final String MSGJVM = "JavaVM: " + MSGJVM0 + " (" + System.getProperty("java.vendor") + ")";
    public static FakeRechner fakeRechner;
    ActionListener exitAction;
    ActionListener windowAction;
    ActionListener regAction;
    ActionListener aboutAction;
    ActionListener runAction;
    ActionListener loadAction;
    ActionListener saveAction;
    ActionListener romLoadAction;
    MenuItem[] windowMenus;
    Rechner rechner;
    Funktionen funktion;
    MemoryWindow[] windows;
    RegisterWindow registerWindow;
    RunWindow runWindow;

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Programm");
        menuBar.add(menu);
        menu.add(Hawt.makeMenuItem("\u00dcber", this.aboutAction, 73));
        if (!FakeApplet.isApplet) {
            menu.add(new MenuItem("-"));
            menu.add(Hawt.makeMenuItem("HEX-Datei laden", this.loadAction, 79));
            menu.add(Hawt.makeMenuItem("HEX-Datei speichern", this.saveAction, 87));
            menu.add(new MenuItem("-"));
            menu.add(Hawt.makeMenuItem("ROM-Datei laden", this.romLoadAction));
        }
        menu.add(new MenuItem("-"));
        menu.add(Hawt.makeMenuItem("Beenden", this.exitAction, 81));
        menu = new Menu("Fenster");
        menuBar.add(menu);
        menu.add(Hawt.makeMenuItem("Register (0x00F2..0x00FF)", this.regAction, 49));
        menu.add(Hawt.makeMenuItem("Emulator-Statistik", this.runAction, 50));
        menu.add(new MenuItem("-"));
        int n = 0;
        while (n < this.windowMenus.length) {
            menu.add(this.windowMenus[n]);
            ++n;
        }
        return menuBar;
    }

    public void resetMP() {
        this.rechner.reset();
        if (this.funktion != null) {
            this.funktion.stop();
        }
        this.funktion = new Funktionen(this);
        this.funktion.setPriority(1);
        this.funktion.start();
    }

    public FakeRechner() {
        super("Praktikumsrechner", false, true);
        FakeRechner fakeRechner = this;
        if (fakeRechner == null) {
            throw null;
        }
        this.exitAction = fakeRechner.new ExitAL();
        FakeRechner fakeRechner2 = this;
        if (fakeRechner2 == null) {
            throw null;
        }
        this.windowAction = fakeRechner2.new WindowAL();
        FakeRechner fakeRechner3 = this;
        if (fakeRechner3 == null) {
            throw null;
        }
        this.regAction = fakeRechner3.new RegAL();
        FakeRechner fakeRechner4 = this;
        if (fakeRechner4 == null) {
            throw null;
        }
        this.aboutAction = fakeRechner4.new AboutAL();
        FakeRechner fakeRechner5 = this;
        if (fakeRechner5 == null) {
            throw null;
        }
        this.runAction = fakeRechner5.new RunAL();
        FakeRechner fakeRechner6 = this;
        if (fakeRechner6 == null) {
            throw null;
        }
        this.loadAction = fakeRechner6.new HexLoad();
        FakeRechner fakeRechner7 = this;
        if (fakeRechner7 == null) {
            throw null;
        }
        this.saveAction = fakeRechner7.new HexSave();
        FakeRechner fakeRechner8 = this;
        if (fakeRechner8 == null) {
            throw null;
        }
        this.romLoadAction = fakeRechner8.new RomLoad();
        this.windowMenus = new MenuItem[]{Hawt.makeMenuItem("ZeroPage (0x0000..0x00FF)", this.windowAction, 51), Hawt.makeMenuItem("RAM A (0x0400..0x0FFF)", this.windowAction, 52), Hawt.makeMenuItem("RAM B (0x1000..0x1FFF)", this.windowAction, 53), Hawt.makeMenuItem("ROM A (0xE000..0xEFFF)", this.windowAction, 54), Hawt.makeMenuItem("Peripherie (0xF000..0xF03F)", this.windowAction, 55), Hawt.makeMenuItem("ROM B (0xF100..0xFFFF)", this.windowAction, 56)};
        this.rechner = new Rechner();
        this.windows = new MemoryWindow[5];
        FakeRechner.fakeRechner = this;
        this.setMenuBar(this.createMenuBar());
        ((Component)this).setBackground(Color.black);
        this.rechner.createTastatur();
        this.rechner.createAnzeige();
        FakeRechner fakeRechner9 = this;
        if (fakeRechner9 == null) {
            throw null;
        }
        this.rechner.getTastatur().addActionListener(fakeRechner9.new TastaturActionListener());
        Hgrid.newLayout(this);
        Hgrid.newItem(1.0, 1.0);
        Hgrid.setInsets(4, 4, 4, 4);
        Hgrid.add(0, 0, this.rechner.getAnzeige(), 2, 1);
        Hgrid.newItem(0.8, 2.0);
        Hgrid.add(1, 1, this.rechner.getTastatur(), 1, 2);
        Hgrid.newItem(0.2, 2.0);
        Hgrid.add(0, 1, new HImage("/feu/fakerechner/fake01.jpg"));
        Hgrid.newItem(0.2, 0.0);
        Label label = new Label("v0.09.004, JVM " + MSGJVM0);
        label.setForeground(Color.white);
        Hgrid.add(0, 2, label);
        this.resetMP();
        this.pack();
        ((Component)this).setLocation(20, 20);
        FakeRechner fakeRechner10 = this;
        if (fakeRechner10 == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(fakeRechner10){
            private final /* synthetic */ FakeRechner this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.exitAction.actionPerformed(null);
            }
            {
                this.this$0 = fakeRechner;
                this.constructor$0(fakeRechner);
            }

            private final void constructor$0(FakeRechner fakeRechner) {
            }
        });
        this.rechner.getTastatur().requestFocus();
    }

    private class TastaturActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getID() == Taste.TASTE_UP) {
                String string = actionEvent.getActionCommand();
                if (string.equals("reset")) {
                    FakeRechner.this.resetMP();
                } else if (!string.equals("f4")) {
                    FakeRechner.this.funktion.addEvent(actionEvent);
                }
            }
        }

        TastaturActionListener() {
        }
    }

    class HexLoad
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Speicher speicher = FakeRechner.this.rechner.getSpeicher();
            int n = speicher.get2x8h(204);
            FileDialog fileDialog = new FileDialog((Frame)fakeRechner, "Datei laden", 0);
            fileDialog.setFile("*.hex");
            fileDialog.show();
            if (fileDialog.getFile() != null) {
                try {
                    HexReader hexReader = new HexReader(new LineNumberReader(new FileReader(fileDialog.getDirectory() + fileDialog.getFile())));
                    hexReader.read();
                    n = HDialog.inputBox((Frame)fakeRechner, "Die Datei " + fileDialog.getFile() + " geht von Adresse $" + Num.getWord(hexReader.getFirstAdr()) + " bis Adresse $" + Num.getWord(hexReader.getLastAdr()) + ".\nMit welchem Offset soll die Datei eingeladen werden?", -1, 0);
                    if (n != -1) {
                        hexReader.toMem(speicher, n);
                    }
                }
                catch (Exception exception) {
                    FakeDialog.ok("Kann Datei nicht laden: " + exception);
                }
            }
        }

        HexLoad() {
        }
    }

    class HexSave
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        HexSave() {
        }
    }

    class ExitAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FakeRechner.this.dispose();
        }

        ExitAL() {
        }
    }

    class AboutAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HDialog.ok(fakeRechner, "Fake-Rechner\nv0.09.004\nby J\u00f6rg Wirtgen (wirtgen@webfabrik.de)\n\n" + MSGSYS + "\n" + MSGJVM);
        }

        AboutAL() {
        }
    }

    class RomLoad
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileDialog fileDialog = new FileDialog((Frame)fakeRechner, "ROM laden", 0);
            fileDialog.setFile("*.rom");
            fileDialog.show();
            if (fileDialog.getFile() != null) {
                try {
                    StreamROM streamROM = FakeRechner.this.rechner.getRomSpeicher();
                    streamROM.load(fileDialog.getDirectory() + fileDialog.getFile());
                }
                catch (Exception exception) {
                    FakeDialog.ok("Kann ROM nicht laden: " + exception);
                }
            }
        }

        RomLoad() {
        }
    }

    class WindowAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            System.out.print("WindowActionListener ");
            int n2 = 0;
            while (n2 < FakeRechner.this.windowMenus.length) {
                if (actionEvent.getSource() == FakeRechner.this.windowMenus[n2]) {
                    n = n2;
                }
                ++n2;
            }
            System.out.println("findet " + n);
            if (n >= 0) {
                if (FakeRechner.this.windows[n] == null) {
                    FakeRechner.this.windows[n] = new MemoryWindow(n);
                }
                FakeRechner.this.windows[n].show();
            }
        }

        WindowAL() {
        }
    }

    class RunAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (FakeRechner.this.runWindow == null) {
                FakeRechner.this.runWindow = new RunWindow();
            }
            FakeRechner.this.runWindow.setVisible(true);
            while (!FakeRechner.this.runWindow.isVisible()) {
            }
            Hthread.sleep(200);
            fakeRechner.toFront();
        }

        RunAL() {
        }
    }

    class RegAL
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (FakeRechner.this.registerWindow == null) {
                FakeRechner.this.registerWindow = new RegisterWindow();
            }
            FakeRechner.this.registerWindow.pack();
            FakeRechner.this.registerWindow.show();
        }

        RegAL() {
        }
    }
}

