/*
 * Decompiled with CFR 0.152.
 */
package feu.fakerechner;

import feu.fakerechner.FakeRechner;
import feu.mrp.Emulator;
import feu.mrp.TaktZaehler;
import feu.mrp.Tastatur;
import feu.mrp.awt.Rechner;
import feu.mrp.memory.Speicher;
import hydro.Hthread;
import hydro.Num;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class Funktionen
extends Thread {
    static byte[] tastenWert = new byte[]{-1, -1, -1, -1, -1, -1, 12, 13, 14, 15, -1, -1, 8, 9, 10, 11, -1, -1, 4, 5, 6, 7, -1, -1, 0, 1, 2, 3, -1, -1};
    private static final int[] LOADDATA = new int[]{58, 137, 0, 153, 0, 169, 132, 185, 4, 0, 201, 0, 217, 0, 233, 5, 249, 5, 0, 139, 0, 155, 0, 171, 130, 187, 0, 0, 203, 0, 219, 0, 235, 131, 251, 16, 16, 195, 32, 32, 211, 0, 227, 140, 32, 243, 16, 16, 132, 0, 148, 0, 164, 141, 16, 32, 180, 16, 16, 196, 0, 212, 0, 228, 131, 244, 16, 16, 28, 0, 72, 88, 79, 95, 15, 0, 111, 136, 85, 127, 240, 16, 134, 0, 150, 0, 166, 137, 1, 2, 182, 1, 0, 198, 0, 214, 0, 230, 134, 246, 18, 35, 204, 0, 0, 220, 0, 236, 133, 252, 0, 0, 16, 206, 0, 0, 16, 222, 0, 16, 238, 139, 16, 254, 18, 35, 206, 0, 0, 222, 32, 238, 128, 254, 35, 52, 142, 0, 0, 158, 35, 174, 129, 190, 52, 52, 16, 142, 0, 0, 16, 158, 0, 16, 174, 130, 16, 190, 0, 0, 31, 67, 18, 126, 4, 0};
    private Rechner rechner;
    private Vector events;

    public void viewText(String string) {
        this.rechner.viewText(string, false);
    }

    public synchronized void addEvent(ActionEvent actionEvent) {
        this.events.addElement(actionEvent);
        this.notify();
    }

    public synchronized String getEvent(boolean bl) {
        String string;
        try {
            while (this.events.size() == 0) {
                this.wait();
            }
            string = ((ActionEvent)this.events.elementAt(0)).getActionCommand();
            if (bl) {
                this.events.removeElementAt(0);
            }
        }
        catch (InterruptedException interruptedException) {
            string = null;
        }
        return string;
    }

    public synchronized byte getNumber() {
        String string = this.getEvent(false);
        byte by = -1;
        int n = 0;
        while (n < 30) {
            if (Tastatur.comm[n].equals(string)) {
                by = tastenWert[n];
            }
            ++n;
        }
        if (by != -1) {
            this.consumeEvent();
        }
        return by;
    }

    public synchronized void consumeEvent() {
        if (this.events.size() > 0) {
            this.events.removeElementAt(0);
        }
    }

    public void nibbleOut(int n) {
        this.viewText("" + Num.getNibble0(n));
    }

    public void byteOut(int n) {
        this.viewText(Num.getByte(n));
    }

    public void wordOut(int n) {
        this.viewText(Num.getWord(n));
    }

    public void adrEdit(int n) {
        Speicher speicher = this.rechner.getSpeicher();
        block0: while (true) {
            this.viewText("\r\t");
            int n2 = speicher.get2x8h(n);
            this.wordOut(n2);
            this.byteOut(speicher.getMem(n2));
            this.viewText("\r\t");
            int n3 = 0;
            while (true) {
                if (n3 >= 4) continue block0;
                byte by = this.getNumber();
                if (by == -1) {
                    return;
                }
                n2 = n2 & ~(15 << (3 - n3) * 4) | by << (3 - n3) * 4;
                speicher.set2x8h(n, n2);
                this.nibbleOut(by);
                ++n3;
            }
            break;
        }
    }

    public void datEdit(int n) {
        Speicher speicher = this.rechner.getSpeicher();
        block0: while (true) {
            this.viewText("\r\t");
            int n2 = speicher.get2x8h(n);
            int n3 = speicher.getMem(n2);
            this.wordOut(n2);
            this.byteOut(n3);
            this.viewText("\r\t\t");
            int n4 = 0;
            while (true) {
                if (n4 >= 2) continue block0;
                byte by = this.getNumber();
                if (by == -1) {
                    return;
                }
                n3 = n3 & ~(15 << (1 - n4) * 4) | by << (1 - n4) * 4;
                speicher.setMem(n2, n3);
                this.nibbleOut(by);
                ++n4;
            }
            break;
        }
    }

    public void parEdit(int[] nArray) {
        Speicher speicher = this.rechner.getSpeicher();
        block0: while (true) {
            this.viewText("\r\t");
            if (nArray[3] == 1) {
                this.byteOut(speicher.getMem(nArray[2]));
            } else {
                this.wordOut(speicher.get2x8h(nArray[2]));
            }
            this.viewText("\r\t");
            int n = 0;
            while (true) {
                if (n >= nArray[3] * 2) continue block0;
                byte by = this.getNumber();
                if (by == -1) {
                    return;
                }
                int n2 = nArray[3] == 1 ? speicher.getMem(nArray[2]) : speicher.get2x8h(nArray[2]);
                n2 = n2 & ~(15 << (nArray[3] * 2 - 1 - n) * 4) | by << (nArray[3] * 2 - 1 - n) * 4;
                if (nArray[3] == 1) {
                    speicher.setMem(nArray[2], n2);
                } else {
                    speicher.set2x8h(nArray[2], n2);
                }
                this.nibbleOut(by);
                ++n;
            }
            break;
        }
    }

    public void tabEdit(String string, int[][] nArray) {
        int n = 0;
        while (true) {
            this.viewText(string + "\t" + (char)nArray[n][0] + (char)nArray[n][1]);
            this.parEdit(nArray[n]);
            String string2 = this.getEvent(false);
            if (string2.equals("+")) {
                if (nArray.length == ++n) {
                    n = 0;
                }
            } else if (string2.equals("-")) {
                n = n == 0 ? nArray.length - 1 : --n;
            } else {
                return;
            }
            this.consumeEvent();
        }
    }

    public void dataIntern() {
        while (true) {
            Speicher speicher = this.rechner.getSpeicher();
            this.datEdit(117);
            String string = this.getEvent(false);
            int n = speicher.get2x8h(117);
            if (string.equals("+")) {
                ++n;
            } else if (string.equals("-")) {
                --n;
            } else {
                return;
            }
            this.consumeEvent();
            speicher.set2x8h(117, n);
        }
    }

    public void befAdr() {
        this.viewText("\r\nAd");
        while (true) {
            Speicher speicher = this.rechner.getSpeicher();
            this.adrEdit(117);
            String string = this.getEvent(false);
            int n = speicher.get2x8h(117);
            if (string.equals("+")) {
                ++n;
            } else if (string.equals("-")) {
                --n;
            } else {
                return;
            }
            this.consumeEvent();
            speicher.set2x8h(117, n);
        }
    }

    public void befData() {
        this.viewText("\r\nDa");
        this.dataIntern();
    }

    public void befReg() {
        int[][] nArray = new int[][]{{32, 65, 245, 1}, {32, 66, 246, 1}, {32, 88, 248, 2}, {32, 89, 250, 2}, {32, 85, 252, 2}, {83, 112, 242, 2}, {80, 99, 254, 2}, {68, 112, 247, 1}, {67, 99, 244, 1}};
        this.tabEdit("\r\nRe", nArray);
    }

    public void befGo(String string) {
        Speicher speicher = this.rechner.getSpeicher();
        boolean bl = false;
        int n = speicher.get2x8h(240);
        if (n != 0) {
            int n2 = speicher.getMem(154);
            speicher.setMem(n, n2);
            speicher.set2x8h(240, 0);
        }
        while (true) {
            if (bl) {
                this.viewText("\r\nSb");
                this.adrEdit(240);
            } else {
                this.viewText(string);
                this.adrEdit(254);
            }
            bl = false;
            String string2 = this.getEvent(false);
            if (string2.equals("+")) {
                bl = true;
                this.consumeEvent();
                continue;
            }
            if (!string2.equals("go")) break;
            if (this.coreGo(speicher)) {
                this.befGo("\r\nBr");
                return;
            }
            string = "\r\nno";
        }
    }

    private boolean coreGo(Speicher speicher) {
        this.viewText("\r\nRunning");
        this.consumeEvent();
        int n = speicher.get2x8h(240);
        if (n != 0) {
            int n2 = speicher.getMem(n);
            speicher.setMem(154, n2);
            speicher.setMem(n, 63);
            if (speicher.getMem(n) != 63) {
                return false;
            }
        }
        Emulator emulator = new Emulator(this.rechner);
        TaktZaehler taktZaehler = this.rechner.getSpeicher().getTakt();
        emulator.init();
        emulator.run();
        emulator.exit();
        int n3 = speicher.get2x8h(254) - 1;
        speicher.set2x8h(254, n3);
        return true;
    }

    public void befLoad() {
        Speicher speicher = this.rechner.getSpeicher();
        int[][] nArray = new int[][]{{111, 102, 204, 2}};
        this.tabEdit("\r\nLo", nArray);
        String string = this.getEvent(false);
        if (string.equals("load")) {
            this.viewText("\r\nLO");
            int n = speicher.get2x8h(204);
            int n2 = 1024 + n;
            int n3 = 0;
            while (n3 < LOADDATA.length) {
                if (n3 % 16 == 0) {
                    this.viewText("\r\t");
                    this.wordOut(n2);
                    Hthread.sleep(100);
                }
                speicher.setMem(n2++, LOADDATA[n3]);
                Hthread.sleep(19);
                ++n3;
            }
            this.viewText("\r\nLoEndeFF");
            this.consumeEvent();
        }
    }

    public void befSave() {
        Speicher speicher = this.rechner.getSpeicher();
        int[][] nArray = new int[][]{{83, 65, 198, 2}, {69, 65, 200, 2}};
        this.tabEdit("\r\nSa", nArray);
        String string = this.getEvent(false);
        if (string.equals("save")) {
            int n = speicher.get2x8h(198);
            int n2 = speicher.get2x8h(200);
            this.viewText("\r\nSA");
            while (n < n2) {
                this.viewText("\r\t");
                this.wordOut(n);
                Hthread.sleep(412);
                n += 16;
            }
            this.viewText("\r\nSave Rdy");
            this.consumeEvent();
        }
    }

    public void befTrace() {
        this.viewText("\r\nTr");
        Emulator emulator = new Emulator(this.rechner);
        Speicher speicher = this.rechner.getSpeicher();
        int n = speicher.get2x8h(254);
        TaktZaehler taktZaehler = speicher.getTakt();
        emulator.init();
        long l = taktZaehler.getTakte();
        emulator.step();
        l = taktZaehler.getTakte() - l;
        emulator.exit();
        n = speicher.get2x8h(254) - n;
        this.befGo("Tr");
    }

    public void beff1() {
        Speicher speicher = this.rechner.getSpeicher();
        this.viewText("\r\nin");
        int n = speicher.get2x8h(117);
        speicher.set2x8h(117, ++n);
        int n2 = 255;
        while (n2 > 0) {
            speicher.setMem(n + n2, speicher.getMem(n + n2 - 1));
            --n2;
        }
        speicher.setMem(n, 255);
        this.dataIntern();
    }

    public void beff2() {
        Speicher speicher = this.rechner.getSpeicher();
        this.viewText("\r\ndE");
        int n = speicher.get2x8h(117);
        int n2 = 0;
        while (n2 < 256) {
            speicher.setMem(n + n2, speicher.getMem(n + n2 + 1));
            ++n2;
        }
        speicher.setMem(n + 256, 255);
        this.dataIntern();
    }

    public void beff3() {
        int[] nArray = new int[]{32, 32, 117, 2};
        this.viewText("\r\ndu");
        this.parEdit(nArray);
        block0: while (true) {
            Speicher speicher = this.rechner.getSpeicher();
            String string = this.getEvent(false);
            int n = speicher.get2x8h(117);
            if (string.equals("+") || string.equals("f3")) {
                n += 4;
            } else if (string.equals("-")) {
                n -= 4;
            } else {
                return;
            }
            this.consumeEvent();
            speicher.set2x8h(117, n);
            this.viewText("\r");
            int n2 = 4;
            while (true) {
                if (n2 <= 0) continue block0;
                this.byteOut(speicher.getMem(n - n2));
                --n2;
            }
            break;
        }
    }

    public void run() {
        while (true) {
            String string;
            if ((string = this.getEvent(true)).equals("adr")) {
                this.befAdr();
                continue;
            }
            if (string.equals("data")) {
                this.befData();
                continue;
            }
            if (string.equals("reg")) {
                this.befReg();
                continue;
            }
            if (string.equals("go")) {
                this.befGo("\r\nGo");
                continue;
            }
            if (string.equals("save")) {
                this.befSave();
                continue;
            }
            if (string.equals("load")) {
                this.befLoad();
                continue;
            }
            if (string.equals("trace")) {
                this.befTrace();
                continue;
            }
            if (string.equals("f1")) {
                this.beff1();
                continue;
            }
            if (string.equals("f2")) {
                this.beff2();
                continue;
            }
            if (string.equals("f3")) {
                this.beff3();
                continue;
            }
            this.viewText("\r\nBefehl ");
        }
    }

    public Funktionen(FakeRechner fakeRechner) {
        this.rechner = fakeRechner.rechner;
        this.events = new Vector(10, 10);
    }
}

