/*
 * Decompiled with CFR 0.152.
 */
package feu.mrp;

import feu.mrp.HexFormatException;
import feu.mrp.memory.Speicherbereich;
import hydro.Num;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class HexReader {
    LineNumberReader in;
    public Vector lines = new Vector(20, 10);

    public void read() throws IOException {
        while (this.readLine()) {
        }
    }

    public Line lineAt(int n) {
        if (n < this.lines.size()) {
            return (Line)this.lines.elementAt(n);
        }
        return null;
    }

    public int getFirstAdr() {
        if (this.lines.size() > 0) {
            return this.lineAt((int)0).adr;
        }
        return 0;
    }

    public int getLastAdr() {
        if (this.lines.size() > 0) {
            Line line = this.lineAt(this.lines.size() - 1);
            return line.adr + line.daten.length - 1;
        }
        return 0;
    }

    public void toMem(Speicherbereich speicherbereich, int n) {
        int n2 = 0;
        while (n2 < this.lines.size()) {
            Line line = (Line)this.lines.elementAt(n2);
            int n3 = 0;
            while (n3 < line.daten.length) {
                speicherbereich.setMem(n + line.adr + n3, line.daten[n3]);
                ++n3;
            }
            ++n2;
        }
    }

    boolean readLine() throws IOException {
        String string = this.in.readLine();
        if (string == null) {
            return false;
        }
        if (string.charAt(0) != ':') {
            throw new HexFormatException("':' am Zeilenanfang fehlt");
        }
        try {
            int n = Integer.valueOf(string.substring(1, 3), 16);
            int n2 = Integer.valueOf(string.substring(3, 7), 16);
            int n3 = Integer.valueOf(string.substring(7, 9), 16);
            int n4 = n + (n2 & 0xFF) + (n2 >> 8) + n3;
            HexReader hexReader = this;
            if (hexReader == null) {
                throw null;
            }
            Line line = hexReader.new Line(n2, n);
            int n5 = 0;
            while (n5 < n) {
                line.daten[n5] = Integer.valueOf(string.substring(n5 * 2 + 9, n5 * 2 + 11), 16).byteValue();
                n4 += line.daten[n5];
                ++n5;
            }
            n5 = Integer.valueOf(string.substring(n * 2 + 9), 16);
            if ((n4 + n5) % 256 != 0) {
                throw new HexFormatException("Checksumme falsch");
            }
            if (n > 0) {
                this.lines.addElement(line);
            }
            return n3 == 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new HexFormatException("Ung\u00fcltige hexadezimale Ziffern gefunden");
        }
        catch (NullPointerException nullPointerException) {
            throw new HexFormatException("Zeile zu kurz");
        }
    }

    public HexReader(LineNumberReader lineNumberReader) {
        this.in = lineNumberReader;
    }

    public class Line {
        public int adr;
        public byte[] daten;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.daten.length * 3 + 6);
            stringBuffer.append(Num.getWord(this.adr));
            stringBuffer.append("  ");
            int n = 0;
            while (n < this.daten.length) {
                stringBuffer.append(Num.getByte(this.daten[n]));
                stringBuffer.append(' ');
                ++n;
            }
            return stringBuffer.toString();
        }

        public Line(int n, int n2) {
            this.adr = n;
            this.daten = new byte[n2];
        }
    }
}

