;
;	fehlerhafte Loesung
;
	ORG	$0400	;Beginn des Programmbereichs

EINGABE	JSR	CLRDISP	;Anzeige loeschen
	CLR	ANZHEX	;Anzahl im Hex.-Format loeschen
	CLR	ANZDEZ	;Anzahl im Dez.-Format loeschen
	LDY	#TABELLE;Y mit Zeiger auf Segmentanzahlen laden
	LDX	#5	;X mit Ausgabeposition laden
	JSR	ZIFFER	;erste Ziffer einlesen
	JSR	ZIFFER	;zweite Ziffer einlesen
	JSR	ZIFFER	;dritte Ziffer einlesen
	JSR	ZIFFER	;vierte Ziffer einlesen
;
;	Nun werden die beiden Zaehler direkt in den Siebensegmentcode
;	gewandelt, um gleich einfacher ausgegeben werden zu koennen.
;
	LDB	ANZHEX	;hexadezimale Anzahl laden...
	JSR	B7SG	;...codieren...
	STD	ANZHEX	;...und wieder speichern
	LDB	ANZDEZ	;dezimale Anzahl laden...
	JSR	B7SG	;...codieren...
	STD	ANZDEZ	;...und wieder speichern
;
;	Nun die Tastaturabfrage und Auswertung der Tasten
;
TASTE	JSR	HALTKEY	;Auf Tastendruck warten
	CMPB	#$87	;Taste "L" gedrueckt?
	BEQ	EINGABE	;ja, zur Eingabe zurueck
	CMPB	#$80	;Taste "+" gedrueckt?
	BEQ	PLUS	;ja, zur Auswertung
	CMPB	#$81	;Taste "-" gedrueckt?
	BNE	TASTE	;nein, zurueck zur Tasteneingabe
;
;	Tasten "+" und "-" auswerten
;
	LDD	ANZHEX	;D mit codierter Anzahl in hexadezimal laden
	LDY	#0	;Y mit "codierter Leere" laden
	BRA	AUSGABE	;zur Ausgabe
PLUS	LDD	#0	;D mit "codierter Leere" laden
	LDY	ANZDEZ	;Y mit codierter Anzahl in dezimal laden
AUSGABE	LDX	#6	;an Position 6...
	JSR	SHOWD	;...wird D ausgegeben (leer oder hex.)
	TFR	Y,D	;Y wird nach D kopiert...
	LDX	#0	;...und an Position 0...
	JSR	SHOWD	;...ausgegeben (leer oder dezimal)
	BRA	TASTE	;Zurueck zur Tasteneingabe
;
;	Unterprogramm ZIFFER
;	Eingabe: Ausgabeposition in X; Tabellenzeiger in Y
;	Ausgabe: -
;	Aendert: X dekrementieren; ANZDEZ, ANZHEX entsprechend hochzaehlen;
;	  A und B zerstoert
;	Die Routine wartet auf eine Hex.-Ziffer und gibt diese an Position X
;	aus. Die Anzahl der Segmente dieser Ziffer werden den zwei 
;	Speicherstellen dazuaddiert.
;
ZIFFER	JSR	HALTKEY	;Auf Tastendruck warten
	BMI	ZIFFER	;Bit 7 gesetzt -> Funktionstaste -> ignorieren
	JSR	SHOWT7SG;Taste in Siebensegmentcode wandeln und ausgeben
	LDA	ANZHEX	;Hex.-Zaehler laden...
	ADDA	B,Y	;...Segmentanzahl addieren...
	STA	ANZHEX	;...und speichern
	LDA	ANZDEZ	;Dezimal-Zaehler laden...
	ADDA	B,Y	;...Segmentzahl addieren...
	DAA		;...BCD-Korrektur...
	STA	ANZDEZ	;...und speichern
	TFR	X,D	;Ausgabeposition nach D kopieren...
	DECB		;...dekrementieren...
	TFR	D,X	;...und wieder nach X kopieren
	RTS		;fertig
;
;	Datenbereich
;
ANZHEX	RMB	1	;hexadezimaler Segmentzaehler
ANZDEZ	RMB	1	;dezimaler Segmentzaehler

;		0 1 2 3 4 5 6 7 8 9 A B C D E F 
TABELLE	FCB	6,2,5,5,4,5,6,3,7,5,6,5,3,5,5,4

U_END	ORG	*	;Ende des Programmbereichs
;==============================================================================
; Konstanten
;
;-----------------------
;parallele Schnittstelle
;-----------------------
DRA	EQU	$?	;Port A: Datenregister
DDRA	EQU	$?	;        Datenrichtungsregister
CRA	EQU	$?	;        Steuerregister
DRB	EQU	$?	;Port B: dto.
DDRB	EQU	$?
CRB	EQU	$?
;
;----------------------
;serielle Schnittstelle
;----------------------
ACDATA  EQU     $?	;ACIA1: Datenregister
ACSTAT  EQU     $?	;       Statusregister
ACCOMM  EQU     $?	;       Befehlsregister (Commandreg.)
ACCONT  EQU     $?	;       Steuerregister (Controlreg.)
;
;-----
;Timer
;-----
TICR1	EQU	$?	;Timer1: Kontrollregister (schreiben)
TILAT1	EQU	$?	;        Latch (schreiben)
TICOU1	EQU	$?	;        Zaehler (lesen)
TICR2	EQU	$?	;Timer3: Kontrollregister (schreiben)
TILAT2	EQU	$?	;        Latch (schreiben)
TICOU2	EQU	$?	;        Zaehler (lesen)
TICR3	EQU	$?	;Timer2: Kontrollregister (schreiben)
TILAT3	EQU	$?	;        Latch (schreiben)
TICOU3	EQU	$?	;        Zaehler (lesen)
TISTAT	EQU	$?	;alle Timer: Statusregister (lesen)
;
;-----------------
;Tastatur, Anzeige
;-----------------
KEY0	EQU	$?	;0te Tastaturspalte
DISP	EQU	$?	;erstes Zeichen im Anzeigepuffer
;
;------------
;Userroutinen
;------------
T7SG     EQU    $?	;Umwandeln der unteren Tetrade von B in 7-Segmentcode
B7SG     EQU    $?	;Umwandeln beider Tetraden von B in 7-Segmentcode
D7SG     EQU    $?	;Umwandeln der vier Tetraden von D in 7-Segmentcode
CLRDISP  EQU    $?	;Loeschen der Anzeige
SHOWA    EQU    $?	;Bringt A in die Anzeige, Position in X
SHOWD    EQU    $?	;Bringt D in die Anzeige, Position in X
SHOWYD   EQU    $?	;Bringt Y,D in die Anzeige, Position in X
SHOWT7SG EQU    $?	;Umwandeln von Tetr. in B, darstellen, Position in X
SHOWB7SG EQU    $?	;Umwandeln von B, darstellen, Position in X
SHOWD7SG EQU    $?	;Umwandeln von D, darstellen, Position in X
CLDBUF   EQU    $?	;Loeschen des Anzeigepuffers
SHOWDBUF EQU    $?	;Uebertragen des Puffers in die Anzeige
RRDBUF   EQU    $?	;Rotieren des Puffers um eine Stelle nach rechts
RLDBUF   EQU    $?	;Rotieren des Puffers um eine Stelle nach links
COPYDBUF EQU    $?	;Kopieren eines zweiten Puffers in den Anzeigepuffer
KEY      EQU    $?	;Lesen der Tastatur ohne Warten, Tastencode nach B
HALTKEY  EQU    $?	;Lesen der Tastatur mit Warten, Tastencode nach B
SHOWKEY  EQU    $?	;Lesen ohne Warten, darstellen, Tastencode nach B
SHOWHKEY EQU    $?	;Lesen mit Warten, darstellen, Tastencode nach B
INDATA   EQU    $?	;Einlesen eines 8-Bit-Wertes nach A, Tastencode nach B
SHOWDATA EQU    $?	;Einlesen nach A, darstellen, Tastencode nach B
INADR    EQU    $?	;Einlesen eines 16-Bit-Wertes nach Y, Tastencode nach B
SHOWADR  EQU    $?	;Einlesen nach Y, darstellen, Tastencode nach B
DLY1MS   EQU    $?	;Schleife zur Zeitverzoegerung, Zeitdauer in Y
RANDOM   EQU    $?	;Pseudo-Zufallszahlen, alter und neuer Wert in Y
COPYXD   EQU    $?	;Kopieren von Speicher, Startadr. in X,Y, Laenge in D
