ANZEIGE		EQU	$0	; 16-bit-Zaehler
MODUS		EQU	$2	; Timer #3 Modus
INTV_T3       	EQU 	$002E    ; Timer #3
SR_T1         	EQU 	$F018    ; Steuerregister Timer #1, SR_T20=1
SR_T3         	EQU 	$F018    ; Steuerregister Timer #3, SR_T20=0
SR_T2         	EQU 	$F019    ; Steueregister Timer #2
STREG         	EQU 	$F019    ; Statusregister Timer #1 - #3
LATCH_T3     	EQU 	$F01E    ; Latch Timer #3


CLRDISP       	EQU 	$F110    ; Anzeige l schen
SHOWD7SG     	EQU 	$F123    ; Wort im 7-Seg.-Code anzeigen
KEY          	EQU 	$F140    ; Tastaturabfrage ohne Halt
HALTKEY       	EQU 	$F143    ; Tastaturabfrage mit Halt

	ORG  	$0400
INIT:   JSR  	CLRDISP  ; Lschen der Anzeige
	LDD  	#T3_TAKT  ; Interrupt-Vektor fr Timer #3
	STD  	<INTV_T3  ;  setzen

	CLR  	SR_T2  ; Steuerregister Timer #3 sel.
	LDA	#$C3	 ; zyklische Zhlweise, ISL
	STA	<MODUS	;
	STA	SR_T3	 ;  programmieren
	LDD	#$FFFF	; 1/2-Hz-Frequenz
	STD	LATCH_T3; festlegen
	LDA  	#$01    ; Steuerregister Timer #1
	STA  	SR_T2    ;   selektieren
	CLR  	SR_T1    ; Timer #3 starten
	CLR  	SR_T2    ; Steuerregister Timer #3 selekt.
	STX	<ANZEIGE	; ANZEIGE l schen
	LDX	#2	; S5-S2 selektieren

LOOP	LDD	<ANZEIGE	; Zhler laden und
  	JSR	SHOWD7SG; darstellen

	LDA	<MODUS	;
  	JSR	KEY		;

	CMPB	#$86		;
	BNE	UNGL2	;
S	ANDA	#$BF		;
 	STA	SR_T3	;
	BRA	LOOP		;
UNGL2	CMPB	#$81		;
	BNE	UNGL3	;
MINUS	ANDA   	#$7F	;
	BRA	STORE	
UNGL3	CMPB	#$80		;
	BNE	STORE	;

PLUS	ORA	#$80		;
STORE	STA	<MODUS	;
  	STA	SR_T3	;
	BRA	LOOP		;

T3_TAKT	LDD	<ANZEIGE	;
	EORA	 #$FF		;
	EORB	 #$FF		;
	STD	<ANZEIGE	;
 	LDA	STREG	;
  	LDD	LATCH_T3;
	RTI			;

		END


