S0	EQU	$10	; Anzeigestelle S0
S1	EQU	$11	; aktueller Ausgabewert
S2	EQU	$12	; Anzeigestelle S2
PUFFER	EQU	$0	; Anzeigepuffer
ZAEHLER EQU	$0000	; Zhler in Speicherstelle 0
PAUSE	EQU	$0004	; Zhler fr Pause
INT_CB1	EQU	$0038	; Interrupt-Vektor fr CB1
INT_CB2	EQU	$003C	; Interrupt-Vektor fr CB2
INT_Z3	EQU	$002E	; Interrupt-Vektor fr Timer #3
SR_Z1	EQU	$F018	; Steuerregister Timer #1
SR_Z3	EQU	$F018	; Steuerregister Timer #3
SR_Z2	EQU	$F019	; Steuerregister Timer #2
STREG	EQU	$F019	; Timer-Statusregister
DRB	EQU	$F002	; Datenregister Port PB
DDRB	EQU	$F002	; Datenrichtungsregister Port PB
CRB	EQU	$F003	; Steuerregister Port PB 
CLRDISP	EQU	$F110	; Anzeige lschen
SHOWA	EQU	$F113
LATCH_Z3 EQU	$F01E	; Latches fr Timer #3
SHOWD	EQU	$F116
SHOWT7SG EQU	$F11C	; Tetrade im 7-Segment-Code darstellen
SHOWB7SG EQU	$F120	; 2-tetraden im 7-Segment-Code darstellen
SHOWD7SG EQU	$F123	; 4-Tetraden im 7-Segment-Code darstellen
SHOWDBUF EQU	$F133	; Puffer in Anzeige
KEY	EQU	$F140	; Tastaturabfrage ohne Halt
HALTKEY	EQU	$F143	; Halten und Tastatur abfragen
INDATA	EQU	$F14C
SHOWDATA EQU	$F150
DLY1MS	EQU	$F160	; 1 ms verzgern

KEY0	EQU	$0
KEY1	EQU	$1
MODE 	EQU	$4
COUNT	EQU	$5

	ORG	$0400	; Programmzhler auf $0400 stellen
	JSR	CLRDISP	; Anzeige lschen
	LDD	#INTZ3	; Beginn der Interruptroutine zu Timer #3 laden und 
	STD	<INT_Z3	; in den Interrupt-Vektor zu Timer #3 bringen

			; Port B initialisieren
	CLR	CRB
	CLR	DDRB
	
	CLR	SR_Z2	; Timer 3 initialisieren
	LDA	#%11000011
	STA	SR_Z3
	LDD	#$FFFF	; 
	STD	LATCH_Z3
	LDA	#1
	STA	SR_Z2

START	LDA	#$36
	STA	CRB
BEGINN	LDB	CRB
	BPL	BEGINN
	LDB	#$FF
	STB	<KEY1
	LDB	DRB	; Lschen Interrupt und Wert einlesen
	STB	<KEY0	; abspeichern
	LDX	#0
	JSR	SHOWB7SG	; Vergleichswert ausgeben
	LDA	#$40	;	Segment g in S7 Modus aktiv
	LDX	#7
	JSR	SHOWA
	CLR	SR_Z1
TEST	TST	<KEY1
	BNE	TEST
	LDB	DRB	; zwischenzeitliche ANforderungen CB1 lschen
	BRA	START

INTZ3	PSHS	D,X,Y
	LDB	<MODE
	EORB	#$FF
	STB	<MODE
	BEQ	RAUS

	LDB	CRB
	EORB	#$08
	STB	CRB

	LDB	<KEY0
	CMPB	<COUNT
	BEQ	EN
	INC	<COUNT
	LDB 	<COUNT	
	LDX	#2
	JSR	SHOWB7SG
	BRA	RAUS

EN	LDA	#1
	STA	SR_Z1
	CLR	<KEY1
	CLRA	
	LDX	#7
	JSR	SHOWA
	CLR	<COUNT
	LDA	#$35
	STA	CRB

RAUS	LDA	STREG
	LDD	LATCH_Z3
	PULS	D,X,Y
	RTI


	END