S0	EQU	$10	; Anzeigestelle S0
S1	EQU	$11	; aktueller Ausgabewert
S2	EQU	$12	; Anzeigestelle S2
PUFFER	EQU	$0	; Anzeigepuffer
ZAEHLER EQU	$0000	; Zhler in Speicherstelle 0
PAUSE	EQU	$0004	; Zhler fr Pause
INT_CB1	EQU	$0038	; Interrupt-Vektor fr CB1
INT_Z3	EQU	$002E	; Interrupt-Vektor fr Timer #3
SR_Z1	EQU	$F018	; Steuerregister Timer #1
SR_Z3	EQU	$F018	; Steuerregister Timer #3
SR_Z2	EQU	$F019	; Steuerregister Timer #2
STREG	EQU	$F019	; Timer-Statusregister
DRB	EQU	$F002	; Datenregister Port PB
DDRB	EQU	$F002	; Datenrichtungsregister Port PB
CRB	EQU	$F003	; Steuerregister Port PB 
CLRDISP	EQU	$F110	; Anzeige lschen
SHOWA	EQU	$F113
LATCH_Z3 EQU	$F01E	; Latches fr Timer #3
SHOWT7SG EQU	$F11C	; Tetrade im 7-Segment-Code darstellen
SHOWB7SG EQU	$F120	; 2-tetraden im 7-Segment-Code darstellen
SHOWD7SG EQU	$F123	; 4-Tetraden im 7-Segment-Code darstellen
SHOWDBUF EQU	$F133	; Puffer in Anzeige
KEY	EQU	$F140	; Tastaturabfrage ohne Halt
HALTKEY	EQU	$F143	; Halten und Tastatur abfragen
SHOWDATA EQU	$F150
DLY1MS	EQU	$F160	; 1 ms verzgern

KEY0	EQU	$0
KEY1	EQU	$1
KEY2	EQU	$2
MODE 	EQU	$4
FLAG	EQU	$5

	ORG	$0400	; Programmzhler auf $0400 stellen
START	JSR	CLRDISP	; Anzeige lschen
	LDD	#INTZ3	; Beginn der Interruptroutine zu Timer #3 laden und 
	STD	<INT_Z3	; in den Interrupt-Vektor zu Timer #3 bringen
	LDD	#INTCB1
	STD	<INT_CB1

			; Port B initialisieren
	CLR	CRB
	CLR	DDRB
	LDA	#$35
	STA	CRB
	
	CLR	SR_Z2	; Timer 3 initialisieren
	LDA	#$C3
	;STA	<MODE
	STA	SR_Z3
	LDD	#$FFFF
	STD	LATCH_Z3
	LDA	#1
	STA	SR_Z2
	
	LDB	#$A
	LDX	#7
	JSR	SHOWT7SG
	LDX	#0
	JSR	SHOWDATA
	STA	<KEY0

	LDB	#$E
	LDX	#7
	JSR	SHOWT7SG
	LDX	#0
	JSR	SHOWDATA
	STA	<KEY1

;	LDB	#$8
;	LDX	#7
;	JSR	SHOWT7SG
;	LDX	#0
;	JSR	SHOWDATA
;	STA	<KEY2

	JSR	CLRDISP

L7	BRA	L7

INTCB1	LDB	DRB
	CMPB	<KEY0
	BEQ	L1
	CMPB	<KEY1
	BEQ	L2
;	CMPB	<KEY2
;	BEQ	L3
	RTI

L1	LDB	#$A
	LDA	#0
	;STA	SR_Z2
	;CLR	SR_Z1
	BRA	L4

L2	LDB	#$E
	LDA	#1
	;STA	SR_Z2
	;STA	SR_Z1
	;BRA	L4

L3	;LDB	#$8	
	;CLR	SR_Z2
	;LDA	<MODE	
	;EORA	#1
	;STA	<MODE
	;STA	SR_Z3	

L4	STA	SR_Z1	
	LDX	#0
	JSR	SHOWT7SG
	LDY	#$0400
	LDA	#$3D
	STA	CRB
	JSR	DLY1MS
	LDA	#$35
	STA	CRB
	JSR	CLRDISP
	RTI

	
INTZ3	LDA	<FLAG
	EORA	#$40
	STA	<FLAG
	LDX	#7
	JSR	SHOWA
	LDA	STREG
	LDD	LATCH_Z3
	RTI


	END